/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class WindowsUtilsTest
extends TestCase {
    int majorVersion;
    int minorVersion;
    Pattern WIN_OS_VERSION = Pattern.compile("^(\\d)+\\.(\\d)+$");

    public void setUp() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        String osVersion = System.getProperty("os.version");
        Matcher m = this.WIN_OS_VERSION.matcher(osVersion);
        if (!m.find()) {
            WindowsUtilsTest.fail((String)("osVersion doesn't look right: " + osVersion));
        }
        this.majorVersion = Integer.parseInt(m.group(1));
        this.minorVersion = Integer.parseInt(m.group(2));
    }

    private boolean isXpOrHigher() {
        if (this.majorVersion < 5) {
            return false;
        }
        return this.minorVersion >= 1;
    }

    public void testLoadEnvironment() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        Properties p = WindowsUtils.loadEnvironment();
        WindowsUtilsTest.assertFalse((String)"Environment appears to be empty!", (boolean)p.isEmpty());
        WindowsUtilsTest.assertNotNull((String)"SystemRoot env var apparently not set on Windows!", (Object)WindowsUtils.findSystemRoot());
    }

    public void testWMIC() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        if (!this.isXpOrHigher()) {
            return;
        }
        WindowsUtilsTest.assertTrue((String)"wmic should be found", ("wmic" != WindowsUtils.findWMIC() ? 1 : 0) != 0);
    }

    public void testTaskKill() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        if (!this.isXpOrHigher()) {
            return;
        }
        WindowsUtilsTest.assertTrue((String)"taskkill should be found", ("taskkill" != WindowsUtils.findTaskKill() ? 1 : 0) != 0);
    }

    public void testRegistry() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        String keyCurrentVersion = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\CurrentVersion";
        String keyProxyEnable = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ProxyEnable";
        String keySeleniumFoo = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\foo";
        WindowsUtilsTest.assertTrue((String)"Standard Windows reg key CurrentVersion doesn't exist", (boolean)WindowsUtils.doesRegistryValueExist((String)keyCurrentVersion));
        System.out.println("CurrentVersion: " + WindowsUtils.readStringRegistryValue((String)keyCurrentVersion));
        WindowsUtilsTest.assertTrue((String)"Standard Windows reg key ProxyEnable doesn't exist", (boolean)WindowsUtils.doesRegistryValueExist((String)keyProxyEnable));
        System.out.println("ProxyEnable: " + WindowsUtils.readIntRegistryValue((String)keyProxyEnable));
        WindowsUtils.writeStringRegistryValue((String)keySeleniumFoo, (String)"bar");
        WindowsUtilsTest.assertEquals((String)"Didn't set Foo string key correctly", (String)"bar", (String)WindowsUtils.readStringRegistryValue((String)keySeleniumFoo));
        WindowsUtils.writeStringRegistryValue((String)keySeleniumFoo, (String)"baz");
        WindowsUtilsTest.assertEquals((String)"Didn't modify Foo string key correctly", (String)"baz", (String)WindowsUtils.readStringRegistryValue((String)keySeleniumFoo));
        WindowsUtils.deleteRegistryValue((String)keySeleniumFoo);
        WindowsUtilsTest.assertFalse((String)"Didn't delete Foo key correctly", (boolean)WindowsUtils.doesRegistryValueExist((String)keySeleniumFoo));
        WindowsUtils.writeBooleanRegistryValue((String)keySeleniumFoo, (boolean)true);
        WindowsUtilsTest.assertTrue((String)"Didn't set Foo boolean key correctly", (boolean)WindowsUtils.readBooleanRegistryValue((String)keySeleniumFoo));
        WindowsUtils.deleteRegistryValue((String)keySeleniumFoo);
        WindowsUtilsTest.assertFalse((String)"Didn't delete Foo key correctly", (boolean)WindowsUtils.doesRegistryValueExist((String)keySeleniumFoo));
    }

    public void testVersion1() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        System.out.println("Version 1: " + WindowsUtils.isRegExeVersion1());
    }
}

