/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.SeleneseCommand;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DefaultSeleneseCommand
implements SeleneseCommand {
    private static final int NUMARGSINCLUDINGBOUNDARIES = 4;
    private static final int FIRSTINDEX = 1;
    private static final int SECONDINDEX = 2;
    private static final int THIRDINDEX = 3;
    private final String command;
    private final String[] args;

    public DefaultSeleneseCommand(String command, String[] args) {
        this.command = command;
        this.args = args;
    }

    public String getCommandURLString() {
        StringBuffer sb = new StringBuffer("cmd=");
        sb.append(DefaultSeleneseCommand.urlEncode(this.command));
        if (this.args == null) {
            return sb.toString();
        }
        for (int i = 0; i < this.args.length; ++i) {
            sb.append('&');
            sb.append(Integer.toString(i + 1));
            sb.append('=');
            sb.append(DefaultSeleneseCommand.urlEncode(this.args[i]));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCommandURLString();
    }

    public static SeleneseCommand parse(String inputLine) {
        if (null == inputLine) {
            throw new NullPointerException("inputLine can't be null");
        }
        String[] values = inputLine.split("\\|");
        if (values.length != 4) {
            throw new IllegalStateException("Cannot parse invalid line: " + inputLine + values.length);
        }
        return new DefaultSeleneseCommand(values[1], new String[]{values[2], values[3]});
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

