/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.HttpCommandProcessor;
import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.TestCase;

public class CSVTest
extends TestCase {
    Method CSV;

    protected void setUp() throws Exception {
        Method[] methods = HttpCommandProcessor.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!"parseCSV".equals(methods[i].getName())) continue;
            Method csvMethod = methods[i];
            csvMethod.setAccessible(true);
            this.CSV = csvMethod;
            break;
        }
    }

    public String[] parseCSV(String input, String[] expected) {
        String[] output;
        System.out.print(input + ": ");
        try {
            output = (String[])this.CSV.invoke(null, (Object[])new String[]{input});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println(Arrays.asList(output).toString());
        this.compareStringArrays(expected, output);
        return output;
    }

    public void testSimple() {
        String input = "1,2,3";
        String[] expected = new String[]{"1", "2", "3"};
        this.parseCSV(input, expected);
    }

    public void testBackSlash() {
        String input = "1,2\\,3,4";
        String[] expected = new String[]{"1", "2,3", "4"};
        this.parseCSV(input, expected);
    }

    public void testRandomSingleBackSlash() {
        String input = "1,\\2,3";
        String[] expected = new String[]{"1", "2", "3"};
        this.parseCSV(input, expected);
    }

    public void testDoubleBackSlashBeforeComma() {
        String input = "1,2\\\\,3";
        String[] expected = new String[]{"1", "2\\", "3"};
        this.parseCSV(input, expected);
    }

    public void testRandomDoubleBackSlash() {
        String input = "1,\\\\2,3";
        String[] expected = new String[]{"1", "\\2", "3"};
        this.parseCSV(input, expected);
    }

    public void testTripleBackSlashBeforeComma() {
        String input = "1,2\\\\\\,3,4";
        String[] expected = new String[]{"1", "2\\,3", "4"};
        this.parseCSV(input, expected);
    }

    public void test4BackSlashesBeforeComma() {
        String input = "1,2\\\\\\\\,3";
        String[] expected = new String[]{"1", "2\\\\", "3"};
        this.parseCSV(input, expected);
    }

    public void compareStringArrays(String[] expected, String[] actual) {
        CSVTest.assertEquals((String)"Wrong number of elements", (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            CSVTest.assertEquals((String)expected[i], (String)actual[i]);
        }
    }
}

