/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.corebased;

import com.thoughtworks.selenium.SeleneseTestCase;

public class TestStore
extends SeleneseTestCase {
    public void testStore() throws Throwable {
        this.selenium.setContext("Test store*", "info");
        this.selenium.open("../tests/html/test_verifications.html");
        String storedHiddenValue = this.selenium.getValue("theHidden");
        String storedSpanText = this.selenium.getText("theSpan");
        String storedTextClass = this.selenium.getAttribute("theText@class");
        String storedTitle = this.selenium.getTitle();
        String textVariable = "PLAIN TEXT";
        String javascriptVariable = this.selenium.getEval("'Pi ~= ' +                     (Math.round(Math.PI * 100) / 100)");
        this.selenium.open("../tests/html/test_store_value.html");
        this.selenium.type("theText", storedHiddenValue);
        TestStore.verifyEquals("the hidden value", this.selenium.getValue("theText"));
        this.selenium.type("theText", storedSpanText);
        TestStore.verifyEquals("this is the span", this.selenium.getValue("theText"));
        this.selenium.type("theText", storedTextClass);
        TestStore.verifyEquals("foo", this.selenium.getValue("theText"));
        this.selenium.type("theText", textVariable);
        TestStore.verifyEquals("PLAIN TEXT", this.selenium.getValue("theText"));
        this.selenium.type("theText", javascriptVariable);
        TestStore.verifyEquals("Pi ~= 3.14", this.selenium.getValue("theText"));
        this.selenium.type("theText", storedTitle);
        TestStore.verifyEquals("theTitle", this.selenium.getValue("theText"));
        this.selenium.type("theText", "'" + storedHiddenValue + "'_'" + storedSpanText + "'");
        TestStore.verifyEquals("'the hidden value'_'this is the span'", this.selenium.getValue("theText"));
        this.selenium.open("../tests/html/test_just_text.html");
        String storedBodyText = this.getText();
        this.selenium.open("../tests/html/test_store_value.html");
        TestStore.verifyEquals("", this.selenium.getValue("theText"));
        this.selenium.type("theText", storedBodyText);
        TestStore.verifyEquals("This is the entire text of the page.", this.selenium.getValue("theText"));
        TestStore.verifyEquals(storedBodyText, "This is the entire text of the page.");
        this.checkForVerificationErrors();
    }
}

