/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;

public class QueueTest
extends TestCase {
    SingleEntryAsyncQueue q;

    public void setUp() {
        this.q = new SingleEntryAsyncQueue();
    }

    public void testClearHungGetter() throws Exception {
        new Thread(){

            public void run() {
                boolean exceptionSeen = false;
                try {
                    QueueTest.this.q.get();
                }
                catch (RuntimeException e) {
                    exceptionSeen = true;
                }
                catch (Throwable e) {
                    Assert.fail((String)("got an unexpected exception: " + e));
                }
                Assert.assertTrue((boolean)exceptionSeen);
            }
        }.start();
        AsyncExecute.sleepTight((long)300L);
        this.q.clear();
    }

    public void testClearHungPutter() throws Exception {
        PuttingThread t = new PuttingThread();
        t.start();
        AsyncExecute.sleepTight((long)1000L);
        this.q.clear();
        t.join();
        QueueTest.assertEquals((String)"ok", (String)t.failureMessage);
    }

    public void testGetFromEmptyQueue() throws Exception {
        this.q.setTimeout(0);
        boolean seleniumCommandTimedOutExceptionSeen = false;
        try {
            this.q.get();
        }
        catch (SeleniumCommandTimedOutException e) {
            seleniumCommandTimedOutExceptionSeen = true;
        }
        QueueTest.assertEquals((boolean)true, (boolean)seleniumCommandTimedOutExceptionSeen);
    }

    public void testMultipleThreadsOrdering() throws Exception {
        int TEST_THREAD_COUNT = 3;
        for (int j = 0; j < TEST_THREAD_COUNT; ++j) {
            QTestThread qt = new QTestThread();
            qt.willPut("thread " + j);
            qt.start();
            while (this.q.size() <= j) {
                System.out.println("main waiting on " + (TEST_THREAD_COUNT - j) + " test threads to all call put()");
                AsyncExecute.sleepTight((long)500L);
            }
        }
        for (int threadNumber = 0; threadNumber < TEST_THREAD_COUNT; ++threadNumber) {
            QueueTest.assertEquals((int)(TEST_THREAD_COUNT - threadNumber), (int)this.q.size());
            System.out.println("main thread reading q...");
            String dataProducingThread = (String)this.q.get();
            System.out.println("main thread read " + dataProducingThread);
            QueueTest.assertEquals((String)("thread " + threadNumber), (String)dataProducingThread);
        }
    }

    public void testTrivial() {
        this.q.put((Object)"hi");
        String s = (String)this.q.get();
        QueueTest.assertEquals((String)"hi", (String)s);
    }

    public void testTrivialx2() {
        this.q.put((Object)"hi");
        this.q.get();
        this.q.put((Object)"there");
        String s = (String)this.q.get();
        QueueTest.assertEquals((String)"there", (String)s);
    }

    class PuttingThread
    extends Thread {
        public String failureMessage = "not set yet";

        PuttingThread() {
        }

        public void run() {
            try {
                QueueTest.this.q.put((Object)"abc");
                QueueTest.this.q.put((Object)"xyz");
            }
            catch (RuntimeException e) {
                this.failureMessage = "ok";
                System.out.println("Putting thread saw expected failure: " + e);
                return;
            }
            catch (Throwable e) {
                this.failureMessage = "got an unexpected exception: " + e;
                return;
            }
            this.failureMessage = "no exception for a putting thread on a queue that got cleared";
        }
    }

    class QTestThread
    extends Thread {
        private Object objToPut;

        QTestThread() {
        }

        public void run() {
            System.out.println("QTestThread.run putting " + this.objToPut);
            QueueTest.this.q.put(this.objToPut);
            System.out.println("QTestThread.run returned from putting " + this.objToPut);
        }

        public void willPut(String s) {
            this.objToPut = s;
        }
    }
}

