/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SeleneseTestCase
extends TestCase {
    protected Selenium selenium;
    protected static StringBuffer verificationErrors = new StringBuffer();

    protected void setUp() throws Exception {
        super.setUp();
        this.setUp(null);
    }

    protected void setUp(String url) throws Exception {
        super.setUp();
        if (url == null) {
            url = "http://localhost:4444";
        }
        this.selenium = new DefaultSelenium("localhost", 4444, "*iexplore", url);
        this.selenium.start();
    }

    public void verifyTrue(boolean b) {
        try {
            SeleneseTestCase.assertTrue((boolean)b);
        }
        catch (Exception e) {
            verificationErrors.append(e);
        }
    }

    public void verifyFalse(boolean b) {
        try {
            SeleneseTestCase.assertFalse((boolean)b);
        }
        catch (Exception e) {
            verificationErrors.append(e);
        }
    }

    protected String getText() {
        return this.selenium.getEval("this.page().bodyText()");
    }

    public static void verifyEquals(Object s1, Object s2) {
        try {
            SeleneseTestCase.assertEquals(s1, s2);
        }
        catch (Exception e) {
            verificationErrors.append(e);
        }
    }

    public static void assertEquals(Object s1, Object s2) {
        if (s1 instanceof String && s2 instanceof String) {
            SeleneseTestCase.assertEquals((String)s1, (String)s2);
        } else {
            String[] sa2;
            String[] sa1;
            if (s1 instanceof String[] && s2 instanceof String[] && (sa1 = (String[])s1).length != (sa2 = (String[])s2).length) {
                throw new AssertionFailedError("Expected " + sa1 + " but saw " + sa2);
            }
            Assert.assertEquals((Object)s1, (Object)s2);
        }
    }

    public static void assertEquals(String s1, String s2) {
        SeleneseTestCase.assertTrue((boolean)SeleneseTestCase.seleniumEquals(s1, s2));
    }

    public static boolean seleniumEquals(String s1, String s2) {
        if (s2.startsWith("regexp:")) {
            String tmp = s2;
            s2 = s1;
            s1 = tmp;
        }
        if (s1.startsWith("regexp:")) {
            String s1regexp = s1.replaceFirst("regexp:", ".*") + ".*";
            if (!s2.matches(s1regexp)) {
                System.out.println("expected " + s2 + " to match regexp " + s1);
                return false;
            }
            return true;
        }
        if (s1.startsWith("exact:")) {
            String s1exact = s1.replaceFirst("exact:", "");
            if (!s1exact.equals(s2)) {
                System.out.println("expected " + s2 + " to match " + s1);
                return false;
            }
            return true;
        }
        String s1glob = s1.replaceFirst("glob:", "");
        s1glob = s1glob.replaceAll("([\\]\\[\\\\{\\}$\\(\\).])", "\\\\$1");
        s1glob = s1glob.replaceAll("\\*", ".*");
        s1glob = "(.|[\r\n])*" + s1glob.replaceAll("\\?", ".") + "(.|[\r\n])*";
        if (!s2.matches(s1glob)) {
            System.out.println("expected \"" + s2 + "\" to match glob \"" + s1 + "\" (had transformed the glob into regexp \"" + s1glob + "\"");
            return false;
        }
        return true;
    }

    public static boolean seleniumEquals(Object s1, Object s2) {
        if (s1 instanceof String && s2 instanceof String) {
            return SeleneseTestCase.seleniumEquals((String)s1, (String)s2);
        }
        return s1.equals(s2);
    }

    public static void assertEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = SeleneseTestCase.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            throw new AssertionFailedError(comparisonDumpIfNotEqual);
        }
    }

    public static void verifyEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = SeleneseTestCase.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            verificationErrors.append(comparisonDumpIfNotEqual);
        }
    }

    private static String verifyEqualsAndReturnComparisonDumpIfNot(String[] s1, String[] s2) {
        boolean misMatch = false;
        if (s1.length != s2.length) {
            misMatch = true;
        }
        for (int j = 0; j < s1.length; ++j) {
            if (s1[j].equals(s2[j])) continue;
            misMatch = true;
            break;
        }
        if (misMatch) {
            return "Expected " + SeleneseTestCase.stringArrayToString(s1) + " but saw " + SeleneseTestCase.stringArrayToString(s2);
        }
        return null;
    }

    private static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer("{");
        for (int j = 0; j < sa.length; ++j) {
            sb.append(" ").append("\"").append(sa[j]).append("\"");
        }
        sb.append(" }");
        return sb.toString();
    }

    public static void verifyNotEquals(String s1, String s2) {
        try {
            SeleneseTestCase.assertNotEquals(s1, s2);
        }
        catch (Exception e) {
            verificationErrors.append(e);
        }
    }

    public static void assertNotEquals(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            SeleneseTestCase.fail((String)("did not expect values to be equal (" + obj1.toString() + ")"));
        }
    }

    protected void pause(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String quote(String value) {
        return "'" + value.replaceAll("'", "\\'") + "'";
    }

    public void checkForVerificationErrors() {
        SeleneseTestCase.assertEquals("", verificationErrors.toString());
    }

    protected void tearDown() throws Exception {
        this.selenium.stop();
    }
}

