/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import java.io.UnsupportedEncodingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class I18nTest
extends TestCase {
    private static String startUrl = "http://localhost:4444";
    private static Selenium sel;

    public static Test suite() {
        return new I18nTestSetup((Test)new TestSuite(I18nTest.class));
    }

    public void testRomance() throws UnsupportedEncodingException {
        String expected = "\u00fc\u00f6\u00e4\u00dc\u00d6\u00c4 \u00e7\u00e8\u00e9 \u00bf\u00f1 \u00e8\u00e0\u00f9\u00f2";
        String id = "romance";
        this.verifyText(expected, id);
    }

    public void testKorean() throws UnsupportedEncodingException {
        String expected = "\uc5f4\uc5d0";
        String id = "korean";
        this.verifyText(expected, id);
    }

    public void testChinese() throws UnsupportedEncodingException {
        String expected = "\u4e2d\u6587";
        String id = "chinese";
        this.verifyText(expected, id);
    }

    public void testJapanese() throws UnsupportedEncodingException {
        String expected = "\u307e\u3077";
        String id = "japanese";
        this.verifyText(expected, id);
    }

    public void testDangerous() throws UnsupportedEncodingException {
        String expected = "&%?\\+|,%*";
        String id = "dangerous";
        this.verifyText(expected, id);
    }

    private void verifyText(String expected, String id) throws UnsupportedEncodingException {
        System.out.println(this.getName());
        System.out.println(expected);
        sel.open(startUrl + "/selenium-server/tests/html/test_i18n.html");
        I18nTest.assertTrue((boolean)sel.isTextPresent(expected));
        String actual = sel.getText(id);
        byte[] result = actual.getBytes("UTF-8");
        for (int i = 0; i < result.length; ++i) {
            Byte b = new Byte(result[i]);
            System.out.println("BYTE " + i + ": " + b.toString());
        }
        I18nTest.assertEquals((String)(id + " characters didn't match"), (String)expected, (String)actual);
    }

    private static class I18nTestSetup
    extends TestSetup {
        public I18nTestSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            try {
                sel = (Selenium)new DefaultSelenium("localhost", 4444, "*firefox", startUrl);
                sel.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void tearDown() throws Exception {
            sel.stop();
        }
    }
}

