using System;

namespace Orciid.Core
{
	/// <summary>
	/// Collection image settings
	/// </summary>
	/// <remarks>
	/// Every collection has individual settings for the image resources associated with images
	/// in that collection.  Each collection has several instances of the ImageSettings structure
	/// to hold the settings for each of the available image sizes (thumbnails, full, etc.)
	/// </remarks>
	public struct ImageSettings
	{
		/// <summary>
		/// Height
		/// </summary>
		/// <remarks>
		/// The maximum height of an image, or if <see cref="fixedsize"/> is <c>true</c>,
		/// the actual height of an image.
		/// </remarks>
		public int height;
		/// <summary>
		/// Width
		/// </summary>
		/// <remarks>
		/// The maximum width of an image, or if <see cref="fixedsize"/> is <c>true</c>,
		/// the actual width of an image.
		/// </remarks>
		public int width;
		/// <summary>
		/// Encoding quality
		/// </summary>
		/// <remarks>
		/// The quality setting for JPEG encoded images.
		/// </remarks>
		public int quality;
		/// <summary>
		/// Maximum/Actual size indicator
		/// </summary>
		/// <remarks>
		/// Specifies if <see cref="width"/> and <see cref="height"/> settings define the
		/// actual size of the images (<c>true</c>; in which case images will be padded with black
		/// if they are not the exact aspect ratio or too small), or the maximum size of the images
		/// (<c>false</c>; in which case images may be smaller, but neither height nor width must
		/// exceed the settings).
		/// </remarks>
		public bool fixedsize;
		/// <summary>
		/// Background color
		/// </summary>
		/// <remarks>
		/// The background color specifies the color of any border that is added to an image to
		/// bring it to a given fixed pixel size.
		/// </remarks>
		public int backgroundcolor;
	}
}
