using System;

namespace DotNetMock.Examples.Mainframe
{
	/// <summary>
	/// Interface to connect and utilize a 3rd party mainframe interface.
	/// This example utilizes NetManage's Rumba api to do screen scraping.
	/// </summary>
	public interface IMainframeConnection
	{
		/// <summary>
		/// Connect to a open Rumba Session.
		/// </summary>
		/// <param name="sessionID">Session ID to connect to</param>
		void Connect(string sessionID);
		/// <summary>
		/// Sets the screen to a predefined mainframe screen.
		/// </summary>
		/// <param name="screenName">Screen to change to</param>
		void SetScreen(string screenName);
		/// <summary>
		/// Puts given text onto the mainframe screen.
		/// </summary>
		/// <param name="row">Row #</param>
		/// <param name="column">Starting Column #</param>
		/// <param name="message">Message to place</param>
		/// <param name="length">Length of Message</param>
		void PutField(int row, int column, string message, int length);
		/// <summary>
		/// Gets the text from the screen.
		/// </summary>
		/// <param name="row">Row #</param>
		/// <param name="column">Column #</param>
		/// <param name="length">Length of the message to get</param>
		/// <returns>Requested text from the screen</returns>
		string GetField(int row, int column, int length);
		/// <summary>
		/// Sends the key to the screen
		/// </summary>
		/// <param name="key">Key to send</param>
		void SendKey(MainframeConnection.Keys key);
		/// <summary>
		/// Waits for control to be returned to the screen
		/// </summary>
		void Wait();
		/// <summary>
		/// Disconnects from the current Mainframe session
		/// </summary>
		void Disconnect();
	}
}
