using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using DotNetMock.Framework.ComponentModel;
using NUnit.Framework;

namespace DotNetMock.Framework.Tests.ComponentModel
{
	[TestFixture]
	public class MockMarshalByValueComponentTests 
	{
		private MockMarshalByValueComponent _mockComponent = null;

		private class DummySite : ISite
		{

		
			#region Implementation of ISite
			public System.ComponentModel.IComponent Component
			{
				get
				{
					return null;
				}
			}

			public System.ComponentModel.IContainer Container
			{
				get
				{
					return null;
				}
			}

			public bool DesignMode
			{
				get
				{
					return true;
				}
			}

			public string Name
			{
				get
				{
					return null;
				}
				set
				{
				}
			}
			#endregion

			#region Implementation of IServiceProvider
			public object GetService(System.Type serviceType)
			{
				return null;
			}
			#endregion
		}


		[SetUp]
		public void Init() 
		{
			_mockComponent = new MockMarshalByValueComponent();	
		}
		[TearDown]
		public void Destroy()
		{
			_mockComponent = null;
		}

		[Test]
		public void ExpectedContainer()
		{
			Container contain =  new Container();
			_mockComponent.SetExpectedContainer( contain );

			Assertion.AssertEquals( "Containers do not equal.", contain, _mockComponent.Container );
		}
		[Test]
		public void ExpectedSite()
		{
			ISite dummySite = new DummySite();
			_mockComponent.SetExpectedSite( dummySite );

			Assertion.AssertEquals( "Sites do not equal.", dummySite, _mockComponent.Site );
		}
		[Test]
		public void ExpectedDesignMode()
		{
			Assertion.Assert( "In design mode", !_mockComponent.DesignMode );
			_mockComponent.SetExpectedSite( new DummySite() );
			_mockComponent.SetExpectedDesignMode( true );
			Assertion.Assert( "Not in design mode", _mockComponent.DesignMode );

			_mockComponent.SetExpectedDesignMode( false );
			Assertion.Assert( "Not in design mode", !_mockComponent.DesignMode );
		}
		[Test]
		public void ExpectedGetServiceCount()
		{
			_mockComponent.SetExpectedGetServiceCalls( 2 );
			_mockComponent.GetService( null );
			_mockComponent.GetService( null );
			_mockComponent.Verify();
		}
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void ExpectedGetServiceCountFails()
		{
			_mockComponent.SetExpectedGetServiceCalls( 3 );
			_mockComponent.GetService( null );
			_mockComponent.GetService( null );
			_mockComponent.Verify();
		}
		[Test]
		public void GetServiceValid()
		{
			IServiceProvider container1 = new ServiceContainer();
			IServiceProvider container2 = new ServiceContainer();

			_mockComponent.SetExpectedServiceProvider( container1, typeof(string) );
			_mockComponent.SetExpectedServiceProvider( container2, typeof(int) );

			Assertion.AssertEquals( "Services do not equal.", container1, _mockComponent.GetService( typeof(string) ) );
			Assertion.AssertEquals( "Services do not equal.", container2, _mockComponent.GetService( typeof(int) ) );
		}
	}
}
