using System;
using System.Security.Principal;
using NUnit.Framework;
using DotNetMock.Framework.Security.Principal;

namespace DotNetMock.Framework.Tests.Security.Principal
{
	[TestFixture]
	public class MockIdentityTests
	{
		private MockIIdentity mockIIdentity = null;

		[SetUp]
		public void Init() 
		{
			mockIIdentity = new MockIIdentity();
		}
		[TearDown]
		public void Destroy()
		{
			mockIIdentity = null;
		}
		[Test]
		public void AuthenticationType() 
		{
			mockIIdentity.SetExpectedAuthenticationType( "NTLM" );
			Assertion.AssertEquals( "NTLM", mockIIdentity.AuthenticationType );
		}
		[Test]
		public void IsAuthenticated() 
		{
			mockIIdentity.SetExpectedIsAuthenticated( true );
			Assertion.Assert( mockIIdentity.IsAuthenticated );
		}
		[Test]
		public void Name() 
		{
			mockIIdentity.SetExpectedName( "Joe User" );
			Assertion.AssertEquals( "Joe User", mockIIdentity.Name );
		}
	}
}
