using System;
using NUnit.Framework;
using DotNetMock;

namespace DotNetMock.Tests
{
	[TestFixture]
	public class ExpectationValueTests
	{
		private ExpectationValue _expectationValue;

		[SetUp]
		public void SetUp() {
			_expectationValue = new ExpectationValue("ExpectationValue");
		}
		
		[TearDown]
		public void TearDown() {
			_expectationValue = null;
		}
		
		[Test]
		public void SetActual() {	
			Object object1 = new Object();

			Assert.IsNull(_expectationValue.Actual);
			_expectationValue.Actual = object1;
			Assert.AreEqual(object1, _expectationValue.Actual);
			
			object1 = null;
		}

		[Test]
		public void SetExpected() {
			Object object2 = new Object();

			Assert.IsNull(_expectationValue.Expected);
			_expectationValue.Expected = object2;
			Assert.AreEqual(object2, _expectationValue.Expected);
			
			object2 = null;
		}
		
		[Test]
		public void HasExpectations() {
			Object object3 = new Object();
			
			_expectationValue.Expected = object3;
			Assert.IsTrue(_expectationValue.HasExpectations);
			
			object3 = null;
		}

		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void Verify()
		{
			int int1 = 3;
			int int2 = 5;
			int int3 = 3;

			_expectationValue.Actual = int1 ;
			_expectationValue.Expected = int2 ;
			_expectationValue.Verify();
				
			_expectationValue.Expected = int3 ;
			_expectationValue.Verify();

		}
		
		[Test]
		public void FailureMode()
		{
			Object object4 = new Object();

			_expectationValue.Expected = object4;

			Assert.IsTrue(_expectationValue.HasExpectations);
			Assert.IsTrue(!(_expectationValue.ShouldCheckImmediate));
			_expectationValue.VerifyImmediate = true;
			Assert.IsTrue(_expectationValue.ShouldCheckImmediate);
			
			object4 = null;
		}

		[Test]
		public void ClearActual()
		{
			Object object5 = new Object();

			Assert.IsNull(_expectationValue.Actual);
			_expectationValue.Actual = object5;
			Assert.IsNotNull(_expectationValue.Actual);
			_expectationValue.ClearActual();
			Assert.IsNull(_expectationValue.Actual);
			
			object5 = null;
		}
		
		[Test]
		public void ClearExpected()
		{
			Object object6 = new Object();

			Assert.IsNull(_expectationValue.Expected);
			_expectationValue.Expected = object6;
			Assert.IsNotNull(_expectationValue.Expected);
			Assert.IsTrue(_expectationValue.HasExpectations);
			_expectationValue.ClearExpected();
			Assert.IsNull(_expectationValue.Expected);
			
			object6 = null;
		}
		[Test]
			public void ShouldCheckImmediate()
		{
			object object7 = new object();
			_expectationValue.Expected = object7;
			_expectationValue.VerifyImmediate = true;
			_expectationValue.Actual = object7;
		}
		[Test]
		public void NullValues()
		{
			_expectationValue.ExpectNothing();
			_expectationValue.ClearActual();
			_expectationValue.Verify();
		}
	}
}
