#define RootLayoutManager

using Root.Reports;
using System;
using System.Data.OleDb;
using System.Drawing;

// Creation date: 08.11.2002
// Checked: 17.12.2002
// Author: Otto Mayer (mot@root.ch)
// Version: 1.01

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - Otto Mayer, Stefan Spirig, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace ReportSamples {
  /// <summary>ADO.NET Sample</summary>
  public class ListLayoutManagerSample : Report {
    private FontDef fd;
    private FontProp fp;
    private Double rMarginLeft = 20;
    private Double rWidth = 175;
    private Double rY = 40;

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates this document</summary>
    protected override void Create() {
      fd = new FontDef(this, FontDef.StandardFont.Helvetica);
      fp  = new FontPropMM(fd, 1.9);

      new Page(this);
      FontProp fp_Title = new FontPropMM(fd, 10);
      page_Cur.AddCB_MM(rY, new RepString(fp_Title, "Layout Manager Sample"));
      fp_Title.rSizeMM = 4;

      // Simple Heading
      rY += 18;
      page_Cur.AddMM(20, rY, new RepString(fp_Title, "List Layout Manager"));
      rY += 5;
      CreateSimpleHeading();
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates this document</summary>
    private void CreateSimpleHeading() {
      using (ListLayoutManager llm = new ListLayoutManager(this)) { 
        llm.rContainerHeightMM = page_Cur.rHeightMM - 65;  // set height of table
        PenProp pp_BorderLine = new PenPropMM(this, 0.4, Color.Blue);
        PenProp pp_GridLine = new PenPropMM(this, 0.1, Color.Blue);

        llm.columnDef.pp_BorderH = pp_BorderLine;
        llm.cellDef.pp_Line = pp_GridLine;

        ListLayoutManager.Column col_Number = new ListLayoutManager.ColumnMM(llm, 10);
        col_Number.cellDef.rAlignH = RepObj.rAlignCenter;
        col_Number.cellDef.pp_LineLeft = pp_BorderLine;
        col_Number.cellDef.rAlignV = RepObj.rAlignCenter;

        ListLayoutManager.Column col_Text = new ListLayoutManager.ColumnMM(llm, 100);
        col_Text.cellDef.textMode = TableLayoutManager.TextMode.MultiLine;

        ListLayoutManager.Column col_Author = new ListLayoutManager.ColumnMM(llm, rWidth - llm.rWidthMM);
        col_Author.cellDef.pp_LineRight = pp_BorderLine;
        col_Author.cellDef.bp_Back = new BrushProp(this, Color.FromArgb(255, 210, 210));
      
        llm.container_CreateMM(page_Cur, rMarginLeft, rY);

        // 1.
        llm.NewRow();
        col_Number.Add(new RepString(fp, "1."));
        col_Text.Add(new RepString(fp, "Rapunzel "));
        col_Author.Add(new RepString(fp, "Gebrder Grimm"));


        // 2.
        llm.cellDef.pp_LineTop = pp_BorderLine;
        col_Text.cellDef.pp_Line = new PenPropMM(this, 0.5, Color.Red);
        col_Text.cellDef.iOrderLineRight = 1;
        col_Text.cellDef.iOrderLineBottom = 1;
        llm.NewRow();
        col_Number.Add(new RepString(fp, "2."));
        col_Text.Add(new RepString(fp, "The Princess and the Pea"));
        col_Author.Add(new RepString(fp, "Hans Christian Andersen"));

        llm.cellDef.pp_LineTop = pp_GridLine;
        col_Text.cellDef.pp_Line = PenProp.pp_Null;

        // 3.
        llm.cellDef.pp_LineTop = pp_BorderLine;
        llm.NewRow();
        col_Number.Add(new RepString(fp, "3."));
        col_Text.Add(new RepString(fp, "Hansel and Gretel"));
        col_Author.Add(new RepString(fp, "Gebrder Grimm"));

      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates a new page</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    private void Tlm_NewContainer(Object oSender, TableLayoutManager.NewContainerEventArgs ea) {
      new Page(this);

      FontProp fp_Title = new FontPropMM(fd, 6);
      fp_Title.bBold = true;
      page_Cur.AddAlignedMM(rMarginLeft + rWidth / 2, RepObj.rAlignCenter, 30, RepObj.rAlignBottom, new RepString(fp_Title, "Customer List"));
      page_Cur.AddMM(rMarginLeft, 40, ea.container);
    }

  }
}
