using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid.Extensions
{
	public class ExtendedResourceDisplay
	{
		public ExtendedResourceDisplay()
		{
		}

		private static System.Web.UI.Control GetDefaultControl(string link, string label)
		{
			if (link == "")
				return new LiteralControl(label);
			HtmlAnchor a = new HtmlAnchor();
			a.HRef = link;
			a.Target = "_blank";
			a.InnerText	= (label == "" ? link : label);
			return a;
		}
		
		public static System.Web.UI.Control GetControl(Page page, ExtendedResource.Record record)
		{
			string label = (record.Label != null && record.Label.Length > 0) ? record.Label : "";
			string link = (record.Link != null && record.Link.Length > 0) ? record.Link : "";
			if (record.Display == ExtendedResource.Display.None || (label == "" && link == ""))
				return null;

			if (record.Display == ExtendedResource.Display.Custom && 
				record.Type == "video/quicktime")
			{
				if (record.Data == "QT_DOWNLOAD")
					return GetDefaultControl(link, label);

				if(!page.IsClientScriptBlockRegistered("AC_QuickTime"))
					page.RegisterClientScriptBlock("AC_QuickTime", 
						String.Format("<script src='{0}' language='JavaScript' type='text/javascript'></script>",
						page.ResolveUrl("~/Extensions/AC_QuickTime.js")));

				string output = "<script language='JavaScript' type='text/javascript'>";

				if (record.Data == "QT_FULLSCREEN")
				{
					output += @"
QT_WriteOBJECT_XHTML('Extensions/watchnow.mov','91','15','',
'href','" + link + @"',
'target','quicktimeplayer',
'controller','false',
'align','absmiddle',
'vspace','5',
'style','margin-top: 5px; margin-bottom: 5px'
);
";
				}
				else if (record.Data == "QT_NORMAL")
				{
					output += @"
QT_WriteOBJECT('Extensions/watchnow.mov','91','15','',
'controller','false',
'autoplay','true',
'loop','false',
'cache','true',
'href','" + link + @"',
'target','quicktimeplayer',
'align','absmiddle',
'vspace','5',
'style','margin-top: 5px; margin-bottom: 5px'
);				
";				
				}
				else
					return new LiteralControl("Extended resource record contains invalid data value");

				output += "</script>&nbsp;" + label;
				return new LiteralControl(output);
			}
			
			// unsupported type, do generic handling
			
			return GetDefaultControl(link, label);
		}
	}
}
