namespace Orciid.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;
	using Orciid.Core;
	using Orciid.PageTemplate;

	public class PrivilegeSelection : OrciidUserControl
	{
		protected System.Web.UI.WebControls.DataGrid PrivilegeGrid;
		private Privilege relevant = Privilege.None;
		private Privilege granted = Privilege.None;
		private Privilege denied = Privilege.None;

		public Privilege RelevantPrivileges
		{
			get
			{
				return relevant;
			}
			set
			{
				relevant = value;
			}
		}

		public Privilege GrantedPrivileges
		{
			get
			{
				return granted;
			}
			set
			{
				granted = value;
			}
		}

		public Privilege DeniedPrivileges
		{
			get
			{
				return denied;
			}
			set
			{
				denied = value;
			}
		}

		protected struct PrivilegeSelectionEntry
		{
			public string label;
			public bool granted;
			public bool denied;

			public string Label
			{
				get
				{
					return label;
				}
			}

			public bool Granted
			{
				get
				{
					return granted;
				}
			}

			public bool Denied
			{
				get
				{
					return denied;
				}
			}
		}

		public override void DataBind()
		{
			base.DataBind();
			ArrayList privs = new ArrayList();
			for (int i = 0; i < 32; i++)
			{
				Privilege p = (Privilege)(1 << i);
				if ((relevant & p) == p)
				{
					PrivilegeSelectionEntry e = new PrivilegeSelectionEntry();
					e.label = GetPrivilegeLabel(p);
					e.granted = ((granted & p) == p);
					e.denied = ((denied & p) == p);
					privs.Add(e);
				}
			}
			PrivilegeGrid.DataSource = privs;
			PrivilegeGrid.DataBind();
		}

		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				base.LoadViewState(savedState);
				relevant = (Privilege)ViewState["relevant"];
			}
		}

		protected override object SaveViewState()
		{
			ViewState["relevant"] = relevant;
			return base.SaveViewState();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (IsPostBack)
			{
				for (int i = 0; i < PrivilegeGrid.Items.Count; i++)
				{
					CheckBox allow = PrivilegeGrid.Items[i].FindControl("allow") as CheckBox;
					CheckBox deny = PrivilegeGrid.Items[i].FindControl("deny") as CheckBox;
					int j = -1;
					int k = 0;
					Privilege p = Privilege.None;
					while (j < i && k < 32)
					{
						p = (Privilege)(1 << k);
						if ((relevant & p) == p)
							j++;
						k++;
					}
					if (k >= 32)
						throw new Exception("Inconsistent relevant privileges");
					if (deny.Checked)
						denied = denied | p;
					else if (allow.Checked)
						granted = granted | p;
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

	}
}
