using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Web;
using System.Web.Services;
using System.Xml;
using System.Xml.Serialization;
using Orciid.Core;

namespace Orciid.WebServices
{
	[WebService(Namespace="http://mdid.jmu.edu/webservices",
		 Description = "MDID Image Manager Service")]
	public class ImageManager : OrciidWebService
	{
		public ImageManager()
		{
			//CODEGEN: This call is required by the ASP.NET Web Services Designer
			InitializeComponent();
		}

		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion

		[WebMethod]
		public string Login(string username, string password)
		{
			CheckSSLRequirement(true);
			Orciid.Core.User user = Orciid.Core.User.GetByLogin(username, password);
			if (user != null)
			{
				string token = "user_" + Guid.NewGuid().ToString();
				Context.Cache.Insert(token, user, null, System.Web.Caching.Cache.NoAbsoluteExpiration, TimeSpan.FromMinutes(20));
				return token;
			}
			else
				return null;
		}

		[WebMethod]
		public void KeepAlive(string token)
		{
			CheckSSLRequirement(false);
			Context.Cache.Get(token);
			//object o = Context.Cache[token];
		}
		
		public struct CollectionInfo
		{
			public int id;
			public string title;
			public ImageSettings full;
			public ImageSettings medium;
			public ImageSettings thumbnail;
		}

		[WebMethod]
		public CollectionInfo[] GetCollectionInfo(string token)
		{
			CheckSSLRequirement(false);
			CollectionInfo[] result = null;
			Orciid.Core.User user = (Orciid.Core.User)Context.Cache[token];
			if (user != null)
			{
				user.Activate(Context.Request.UserHostAddress);
				Collection[] colls = Collection.GetCollections(CollectionType.Internal);
				if (colls != null && colls.Length > 0)
				{
					ArrayList temp = new ArrayList();
					foreach (Collection coll in colls)
					{
						if (Orciid.Core.User.HasPrivilege(Privilege.ManageCollection & Privilege.ModifyImages, coll))
						{
							CollectionInfo info = new CollectionInfo();
							info.id = coll.ID;
							info.title = coll.Title;
							info.full = coll.GetImageSettings(ImageSize.Full);
							info.medium = coll.GetImageSettings(ImageSize.Medium);
							info.thumbnail = coll.GetImageSettings(ImageSize.Thumbnail);
							temp.Add(info);
						}
					}
					result = (CollectionInfo[])temp.ToArray(typeof(CollectionInfo));
				}
			}
			return result;
		}

		public struct ImageInfo
		{
			public string id;
			public string resource;
			public string full;
			public string medium;
			public string thumb;
		}

		[WebMethod]
		public ImageInfo[] GetCollectionData(string token, int collectionid)
		{
			CheckSSLRequirement(false);
			ImageInfo[] result = null;
			Orciid.Core.User user = (Orciid.Core.User)Context.Cache[token];
			if (user != null)
			{
				user.Activate(Context.Request.UserHostAddress);
				Collection coll = Collection.GetByID(collectionid);
				if (coll != null)
				{
					int resourcepathlength = coll.PhysicalResourcePathRoot.Length;
					ArrayList temp = new ArrayList();
					Hashtable images = coll.GetAllImageResources(false, false);
					foreach (ImageIdentifier i in images.Keys)
					{
						ImageInfo info = new ImageInfo();
						info.id = i.ToString();
						info.resource = (string)images[i];
						info.full = coll.MapResource(info.resource, ImageSize.Full).Substring(resourcepathlength);
						info.medium = coll.MapResource(info.resource, ImageSize.Medium).Substring(resourcepathlength);
						info.thumb = coll.MapResource(info.resource, ImageSize.Thumbnail).Substring(resourcepathlength);
//						info.hasresources = coll.HasAllResourceVersions(info.resource);						
						temp.Add(info);
					}
					result = (ImageInfo[])temp.ToArray(typeof(ImageInfo));
				}
			}
			return result;
		}

		[WebMethod]
		public string[] GetAvailableResources(string token, int collectionid)
		{
			CheckSSLRequirement(false);
			string[] result = null;
			Orciid.Core.User user = (Orciid.Core.User)Context.Cache[token];
			if (user != null)
			{
				user.Activate(Context.Request.UserHostAddress);
				Collection coll = Collection.GetByID(collectionid);
				if (coll != null)
				{
					result = coll.GetAvailableFiles();
				}
			}
			return result;
		}

		[WebMethod]
		public bool SetResourceData(string token, string sid, ImageSize format, byte[] data)
		{
			CheckSSLRequirement(false);
			Orciid.Core.User user = (Orciid.Core.User)Context.Cache[token];
			if (user != null)
			{
				user.Activate(Context.Request.UserHostAddress);
				ImageIdentifier id;
				try
				{
					id = ImageIdentifier.Parse(sid);
				}
				catch (CoreException)
				{
					return false;
				}
				Collection coll = Collection.GetByID(id.CollectionID);
				Image image = Image.GetByID(id);
				if (coll != null && image != null)
				{
					return coll.SetRawResourceData(image.Resource, format, data);
				}
			}
			return false;
		}
	}
}
