using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class AddSlides : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.TextBox TitleTextBox;
		protected System.Web.UI.WebControls.Button CreateButton;
		protected System.Web.UI.WebControls.DropDownList NewShowFolderList;
		protected System.Web.UI.WebControls.DropDownList ExistingShowFolderList;
		protected System.Web.UI.WebControls.DropDownList SlideshowList;
		protected System.Web.UI.WebControls.Button AddSlidesButton;
		protected System.Web.UI.WebControls.CheckBox ArchivedCheckBox;
		protected System.Web.UI.WebControls.Label ErrorSlideshowLabel;
		protected System.Web.UI.WebControls.Label ErrorTitleLabel;
		protected System.Web.UI.WebControls.Panel AddSlidesPanel;
		protected System.Web.UI.WebControls.Label CurrentSlideshowLabel;
		protected System.Web.UI.WebControls.Button AddToCurrentButton;
		protected System.Web.UI.WebControls.Panel NoImagesSelectedPanel;
		protected System.Web.UI.WebControls.LinkButton AddImagesLinkButton;
		protected System.Web.UI.WebControls.LinkButton ResultButton;
		protected System.Web.UI.HtmlControls.HtmlGenericControl AddToCurrentDiv;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NoImagesSelectedSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DescriptionParagraph;
		protected System.Web.UI.HtmlControls.HtmlGenericControl AddToCurrentSlideshowHeadingSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl AddToNewSlideshowHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NewTitleLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NewInFolderLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl AddToExistingSlideshowHeading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl ExistingFolderLabelSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl ExistingSlideshowLabelSpan;
	
		private Properties userprops;

		private void Page_Load(object sender, System.EventArgs e)
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			userprops = Properties.GetProperties(user);
			if (!IsPostBack)
			{
				int currentShow = 0;
				string currentShowFolder = "0";
				if (Session["CurrentSlideshow"] != null)
				{
					currentShow = (int)Session["CurrentSlideshow"];
					Slideshow show = Slideshow.GetByID(currentShow);
					if (show != null)
					{
						currentShowFolder = show.Folder.ToString();
						CurrentSlideshowLabel.Text = show.Title;
						if (userprops != null && 
							userprops.Get("addslidestoshow", "select") == "current")
							AddSlidesToShow(show);
					}
				}
				SortedList folders = user.GetFolders();
				folders.Add(GetLocalString(this, "MainFolder", "[Main]"), 0);
				NewShowFolderList.DataSource = folders;
				NewShowFolderList.DataTextField = "Key";
				NewShowFolderList.DataValueField = "Value";
				NewShowFolderList.DataBind();
				ExistingShowFolderList.DataSource = folders;
				ExistingShowFolderList.DataTextField = "Key";
				ExistingShowFolderList.DataValueField = "Value";
				ExistingShowFolderList.DataBind();
				for (int i = 0; i < ExistingShowFolderList.Items.Count; i++)
					if (ExistingShowFolderList.Items[i].Value == currentShowFolder)
					{
						ExistingShowFolderList.SelectedIndex = i;
						break;
					}
				ListExistingShows();
				for (int i = 0; i < SlideshowList.Items.Count; i++)
					if (SlideshowList.Items[i].Value == currentShow.ToString())
					{
						SlideshowList.SelectedIndex = i;
						break;
					}
				ArrayList selectedImages = Session["SelectedImages"] as ArrayList;
				if (selectedImages != null && selectedImages.Count > 0)
				{
					AddSlidesPanel.Visible = true;
					NoImagesSelectedPanel.Visible = false;
				}
				else
				{
					AddSlidesPanel.Visible = false;
					NoImagesSelectedPanel.Visible = true;
				}
			}
			AddToCurrentDiv.Visible = (Session["CurrentSlideshow"] != null);
			ArchivedCheckBox.Visible = Orciid.Core.User.HasPrivilege(Privilege.PublishSlideshow, user);
		}

		private void ListExistingShows()
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			Slideshow[] shows = Slideshow.GetByFolder(user.ID, Int32.Parse(ExistingShowFolderList.SelectedItem.Value));
			SlideshowList.Items.Clear();
			SlideshowList.Items.Add(new ListItem(shows.Length == 0 ? 
				GetLocalString(this, "NoSlideshowsInFolder", "[No Slideshows in this Folder]") : "", "0"));
			foreach (Slideshow show in shows)
				SlideshowList.Items.Add(new ListItem(show.Title, show.ID.ToString()));
		}

		public override string GetHighlightedMenuItem()
		{
			return "";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return true;
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ResultButton.Click += new System.EventHandler(this.ResultButton_Click);
			this.AddImagesLinkButton.Click += new System.EventHandler(this.AddImagesLinkButton_Click);
			this.AddToCurrentButton.Click += new System.EventHandler(this.AddToCurrentButton_Click);
			this.CreateButton.Click += new System.EventHandler(this.CreateButton_Click);
			this.ExistingShowFolderList.SelectedIndexChanged += new System.EventHandler(this.ExistingShowFolderList_SelectedIndexChanged);
			this.AddSlidesButton.Click += new System.EventHandler(this.AddSlidesButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void ResultButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("result.aspx"); 
		}

		private void ExistingShowFolderList_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ListExistingShows();
		}

		private void CreateButton_Click(object sender, System.EventArgs e)
		{
			if (TitleTextBox.Text.Length > 0)
			{
				Slideshow show = new Slideshow();
				show.ArchiveFlag = ArchivedCheckBox.Checked;
				show.Title = TitleTextBox.Text;
				show.Folder = Int32.Parse(NewShowFolderList.SelectedItem.Value);
				AddSlidesToShow(show);
			}
			else
				ErrorTitleLabel.Visible = true;
		}

		private void AddSlidesButton_Click(object sender, System.EventArgs e)
		{
			Slideshow show = Slideshow.GetByID(Int32.Parse(SlideshowList.SelectedItem.Value));
			if (show != null)
				AddSlidesToShow(show);
			else
				ErrorSlideshowLabel.Visible = true;
		}

		private void AddSlidesToShow(Slideshow show)
		{
			ArrayList selectedImages = Session["SelectedImages"] as ArrayList;
			if (selectedImages != null)
			{
				bool addtoscratch = (show.GetSlides().Length > 0);
				if (userprops != null)
					switch (userprops.Get("addslidestoarea", "auto"))
					{
						case "presentation":
							addtoscratch = false;
							break;
						case "scratch":
							addtoscratch = true;
							break;
					}
				foreach (ImageIdentifier id in selectedImages)
				{
					Slide slide = new Slide();
					slide.ImageID = id;
					slide.Scratch = addtoscratch;
					show.Add(slide);
				}
				show.Update();
				Session["CurrentSlideshow"] = show.ID;
				Session["SelectedImages"] = null;
				if (userprops != null && 
					userprops.Get("goafteraddslides", "properties") == "lighttable")
					Response.Redirect(String.Format("lighttable.aspx?ssid={0}&url={1}", 
						show.ID, Server.UrlEncode(String.Format("slideshow.aspx?id={0}", show.ID))));
				else
					Response.Redirect(String.Format("slideshow.aspx?id={0}", show.ID));
			}
		}

		private void AddToCurrentButton_Click(object sender, System.EventArgs e)
		{
			if (Session["CurrentSlideshow"] != null)
			{
				Slideshow show = Slideshow.GetByID((int)Session["CurrentSlideshow"]);
				if (show != null)
					AddSlidesToShow(show);
			}		
		}

		private void AddImagesLinkButton_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("addimages.aspx"); 
		}
	}
}
