using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class backgroundtasks : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.Label TaskLabel;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl RefreshPara;
	
		private const string AutoRefreshJavaScript = 
			@"<script language='JavaScript'><!--
setInterval('window.location.href=\'backgroundtasks.aspx\';',10000);
//--></script>";

		private void Page_Load(object sender, System.EventArgs e)
		{
			TaskLabel.Text = String.Join("\n", BackgroundTask.TaskQueue());
			if (!this.IsClientScriptBlockRegistered("autorefreshpage"))
				this.RegisterClientScriptBlock("autorefreshpage", AutoRefreshJavaScript);
		}

		public override string GetHighlightedMenuItem()
		{
			return "Management_BackgroundTasks";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return (user != null && user.Administrator);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
