using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class ImageUse : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.DataGrid SlideshowDataGrid;
		protected System.Web.UI.WebControls.PlaceHolder ImageRecordPlaceHolder;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			Analysis.ImageUseInfo[] info = Analysis.GetImageInSlideshowInfo(GetID());
			if (info == null)
			{
				ShowError(GetLocalString(this, "ImageNotFound", "The requested image could not be found."));
			}
			else if (info.Length == 0)
			{
				ShowInformation(GetLocalString(this, "ImageNotUsed", "The requested image is not in use in any slideshows."));
			}
			else
			{
				SlideshowDataGrid.DataSource = info;
				SlideshowDataGrid.DataBind();

				UserControls.ImageRecordDisplay display = LoadControl("UserControls/ImageRecordDisplay.ascx") as UserControls.ImageRecordDisplay;
				display.DataSource = Orciid.Core.Image.GetByID(info[0].id);
				display.ViewMode = ViewMode.Long;
				display.EnableViewState = false;
				ImageRecordPlaceHolder.Controls.Add(display);
				display.DataBind();
			}
		}

		protected string GetUserName(object DataItem)
		{
			Orciid.Core.User user = ((Analysis.ImageUseInfo)DataItem).user;
			if (user != null)
				return user.FullName;
			else
				return GetLocalString(this, "InaccessibleUser", "(inaccessible user)");
		}

		protected string GetUserEmail(object DataItem)
		{
			Orciid.Core.User user = ((Analysis.ImageUseInfo)DataItem).user;
			if (user != null)
				return user.Email;
			else
				return GetLocalString(this, "InaccessibleUser", "(inaccessible user)");
		}

		protected string GetSlideshowTitle(object DataItem)
		{
			Slideshow show = ((Analysis.ImageUseInfo)DataItem).show;
			if (show != null)
				return show.Title;
			else
				return GetLocalString(this, "InaccessibleSlideshow", "(inaccessible slideshow)");
		}

		protected string GetSlideshowUrl(object DataItem)
		{
			Slideshow show = ((Analysis.ImageUseInfo)DataItem).show;
			if (show != null)
			{
				if (Orciid.Core.User.HasPrivilege(Privilege.ModifySlideshow, show))
					return String.Format("slideshow.aspx?id={0}", show.ID);
				else if (Orciid.Core.User.HasPrivilege(Privilege.ViewSlideshow, show))
					return String.Format("slideshowviewer.aspx?ssid={0}", show.ID);
			}
			return "";
		}

		protected string GetFolderName(object DataItem)
		{
			Slideshow show = ((Analysis.ImageUseInfo)DataItem).show;
			Orciid.Core.User user = ((Analysis.ImageUseInfo)DataItem).user;
			if (show != null && user != null)
			{
				return user.GetFolderName(show.Folder);
			}
			return "";
		}

		public override string GetHighlightedMenuItem()
		{
			return null;
		}

		private ImageIdentifier GetID()
		{
			try
			{
				return ImageIdentifier.Parse(Request.QueryString["id"]);
			}
			catch
			{
				return new ImageIdentifier(0, 0);
			}
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			Collection coll = Collection.GetByID(GetID().CollectionID);
			return (coll != null && 
				(Orciid.Core.User.HasPrivilege(Privilege.ModifyImages, coll, user) ||
				Orciid.Core.User.HasPrivilege(Privilege.CreateSlideshow, user)));
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
