using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.IO;
using Orciid.Core;

namespace orciid.imgview
{
	/// <summary>
	/// Summary description for getimage.
	/// </summary>
	public class getimage : System.Web.UI.Page
	{
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			string tokenkey = "";
			string imageid = "";
			bool tokenisvalid = false;
			try 
			{
				tokenkey = "IVtoken" + Request.QueryString.GetValues("t")[0].ToString();
				imageid = Request.QueryString.GetValues("i")[0].ToString();
				foreach(string item in Application.Contents) 
				{
					if (item == tokenkey) 
					{
						if (DateTime.Compare(((Token)Application.Get(item)).timestamp, DateTime.Now) >= 0) 
						{
							tokenisvalid = true;
							Token token = (Token)Application.Get(item);
							token.timestamp = DateTime.Now + System.TimeSpan.FromMinutes(60);
							Application.Set(tokenkey, token);
						}
						break;
					}
				}
				if (!tokenisvalid) 
				{
					Response.Status = "401 Unauthorized";
					Response.End();
				}
			} 
			catch 
			{
				Response.Status = "401 Unauthorized";
				Response.End();
			}
			if (!tokenisvalid || imageid.Length < 3) 
			{
				Response.Status = "401 Unauthorized";
				Response.End();
				return;
			}
			string[] imageparts = imageid.Split("_".ToCharArray(), 2);
			if (imageparts.Length < 2) 
			{
				Response.Status = "401 Unauthorized";
				Response.End();
				return;
			}
			Stream stream = null;
			((Token)(Application[tokenkey])).user.Activate(Request.UserHostAddress);
			Collection coll = Collection.GetByID(Int32.Parse(imageparts[0]));
			if (coll != null) 
			{
				stream = coll.GetResourceData(imageparts[1], ImageSize.Full);
				Response.ContentType = "image/jpeg";
				if (stream == null)
				{
					stream = Collection.RenderMessage("Image is unavailable", ImageSize.Full);
				}
				Response.ContentType = "image/jpeg";
				Response.AppendHeader("Content-Length", stream.Length.ToString());
				byte[] buffer = new byte[16384];
				int bytesread;
				do
				{
					bytesread = stream.Read(buffer, 0, 16384);
					if (bytesread > 0)
						Response.OutputStream.Write(buffer, 0, bytesread);
				} while (Response.IsClientConnected && bytesread > 0);
				stream.Close();
				Response.End();
			}
			else
			{
				Response.Status = "401 Unauthorized";
				Response.End();
				return;
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
