<%@ Reference Control="UserControls/ImageRecordDisplay.ascx" %>
<%@ Page language="c#" Codebehind="result.aspx.cs" AutoEventWireup="false" Inherits="Orciid.result" ValidateRequest="false" %>
<%@ Import namespace="Orciid.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
		<title id="PageTitle" runat="server">Search Results</title>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script language="javascript">
		function popupviewer(imageid) {
			w = window.open('slideviewer.aspx?iid=' + imageid,'popupviewer','width=640,height=480,directories=no,toolbar=no,resizable=yes,menubar=no,scrollbars=no');
			w.focus();
		}
		
		// Added February 2007 - Carl Marshall, ACDT, University of Oxford
		// Description: This function combined with the reformated display template and the style classes, allows you to toggle the results between a list view complete with metadata, and a thumbnail based table view.
		function flexResults() {
			var a=document.getElementById("flexToggle");
			if (a.innerHTML=="Table View") {
				// Loop through all elements in the list, and set the class of the second div to MetaDataOff
				var list = document.getElementById("listResults");
				var array = list.getElementsByTagName("div");
				for (i=0;i<array.length;i++) {
					if(array[i].className=="oxMetadataOn") {
						array[i].className="oxMetadataOff";
					}
				}
				// Reformat the list items as well as the divs
				var array = list.getElementsByTagName("li");
				for (i=0;i<array.length;i++) {
					array[i].className = "tableview";
				}
				// Finally, toggle the switch for the next cycle
				a.innerHTML = "List View";
			}
			else {
				// Loop through all elements in the list, and set the class of the second div to MetaDataOn
				var list = document.getElementById("listResults");
				var array = list.getElementsByTagName("div");
				for (i=0;i<array.length;i++) {
					if(array[i].className=="oxMetadataOff") {
						array[i].className="oxMetadataOn";
					}
				}
				// Reformat the list items as well as the divs
				var array = list.getElementsByTagName("li");
				for (i=0;i<array.length;i++) {
					array[i].className = "listview";
				}
				// Finally, toggle the switch for the next cycle
				a.innerHTML = "Table View";
			}
			// Refresh the table style to ensure the page is formatted well...
			document.getElementById("tableResults").width="100%";
		}
		</script>
		<style type="text/css">
			ul.oxSearch, ul.oxSearch li {
				list-type: none;
				margin: 0;
				padding: 0;
			}
			ul.oxSearch li.listview {
				display: block;
				width: 100%;
				padding-bottom: 5px;
				border-bottom: 2px solid #ccc;
				margin-bottom: 5px;
			}
			ul.oxSearch li.tableview {
				float: left;
				display: inline;
				width: 100px;
				border: 0;
				padding: 0;
				margin: 0;
			}

			div.oxThumbnail {
				width: 100px;
			}
			div.oxMetadataOff {
				display: none;
				visibility: hidden;
			}
			div.oxMetadataOn {
				display: block;
				visibility: inherit;
				width: 100%;
				clear:right;
			}
		</style>
	</head>
	<body>
		<form method="post" runat="server">
			<h1 id="Title" runat="server">Search Results</h1>
			<p runat="server"><span id="ShowLabel" runat="server">Show</span>
				<asp:dropdownlist ID="RecordsPerPageList" runat="server" AutoPostBack="True">
					<asp:listitem Value="10" selected="True">10</asp:listitem>
					<asp:listitem Value="25">25</asp:listitem>
					<asp:listitem Value="50">50</asp:listitem>
				</asp:dropdownlist>
				<span id="RecordsPerPageLabel" runat="server">records per page</span> <span id="SortBySpan" runat="server">
					<span id="SortedByLabel" runat="server">, sorted by</span>
					<asp:dropdownlist ID="SortByList" runat="server" AutoPostBack="True"></asp:dropdownlist></span>.
				<span runat="server" id="ShowInfoLabel">Show</span>
				<asp:dropdownlist ID="ViewModeList" runat="server" AutoPostBack="True"></asp:dropdownlist>
				<span id="InformationLabel" runat="server">information.</span>
			</p>
			<p>
				<asp:linkbutton ID="BackLinkButton" runat="server"></asp:linkbutton>&nbsp;
				<asp:linkbutton ID="SelectAllOnPageLinkButton" runat="server">Select All on Page</asp:linkbutton>&nbsp; 
				Filter by keyword:
				<asp:textbox ID="FilterTextBox" runat="server"></asp:textbox>&nbsp;
				<asp:button ID="FilterButton" runat="server" Text="Filter" causesvalidation="False"></asp:button>
			</p>
			<p><a id="flexToggle" href="javascript:flexResults()">Table View</a></p>
			<table cellpadding="3" cellspacing="0" border="0" id="tableResults" width="100%">
				<tr style="BACKGROUND-COLOR: #eeeeee">
					<td nowrap><asp:button Width="30" ID="FirstPageButton" runat="server" Text="<<" EnableViewState="False"></asp:button><asp:button Width="30" ID="PrevPageButton" runat="server" Text="<" EnableViewState="False"></asp:button></td>
					<td nowrap align="center">
						<span id="PageLabel" runat="server">Page</span>
						<asp:label ID="CurrentPageLabel" runat="server" Text='<%# CurrentPage %>' EnableViewState="False">
						</asp:label>
						<span id="OfPagesLabel" runat="server">of</span>
						<asp:label ID=TotalPagesLabel runat="server" Text='<%# TotalPages %>' EnableViewState="False">
						</asp:label>&nbsp;(<asp:label ID=NumRecordsLabel runat="server" Text='<%# NumRecords %>' EnableViewState="False"></asp:label>
						<span runat="server" id="RecordsFoundLabel">records found</span>)
					</td>
					<td nowrap align="right">
						<asp:button Width="30" ID="NextPageButton" runat="server" Text=">" EnableViewState="False"></asp:button><asp:button Width="30" ID="LastPageButton" runat="server" Text=">>" EnableViewState="False"></asp:button>
					</td>
				</tr>
				<tr>
					<td colspan="3">
					<ul class="oxSearch" id="listResults">
							<asp:repeater ID="R" runat="server" EnableViewState="True">
								<itemtemplate>
									<li class="listview">
										<div class="oxThumbnail"><a name="anchor<%# GetImageIdentifier(Container.DataItem) %>" href="<%# GetPopupUrl(Container.DataItem) %>">
												<asp:image Height="72" Width="96" runat="server" EnableViewState="False" BorderWidth="0" ImageUrl="<%# ThumbnailPath(Container.DataItem) %>">
												</asp:image></a>
											<asp:image ImageUrl="images/owner.gif" runat="server" OnDataBinding="DataBindOtherOwnerImage"
												Width="24" Height="24" Visible="False" EnableViewState="False" />
											<div runat="server">
												<asp:checkbox ID="s" EnableViewState="True" runat="server" Text="Selected" OnDataBinding="DataBindSelectImage"
													OnCheckedChanged="SelectCheckBoxChanged"></asp:checkbox>
											</div>
											<div runat="server">
												<asp:checkbox ID="f" EnableViewState="True" runat="server" Text="Favorite" OnDataBinding="DataBindFavoriteImage"
													OnCheckedChanged="FavoriteCheckBoxChanged"></asp:checkbox>
											</div>
											<div runat="server">
												<asp:checkbox ID="p" EnableViewState="True" runat="server" Text="Shared" OnDataBinding="DataBindShareImage"
													OnCheckedChanged="ShareCheckBoxChanged"></asp:checkbox>
											</div>
											<div runat="server">
												<asp:checkbox ID="i" EnableViewState="True" runat="server" Text="Suggest" OnDataBinding="DataBindSuggestImage"
													OnCheckedChanged="SuggestCheckBoxChanged"></asp:checkbox><br />
												<asp:label ID="j" runat="server" Visible="False" EnableViewState="False" ForeColor="#666666"
													Text="&nbsp;(Inclusion rejected)"></asp:label>
											</div>
											<div runat="server">
												<asp:linkbutton runat="server" CommandName="accept" EnableViewState="True" OnDataBinding="DataBindAcceptLinkButton" ID="DataBindAcceptLinkButton">Accept Image</asp:linkbutton><br />
												<asp:linkbutton runat="server" CommandName="reject" EnableViewState="True" OnDataBinding="DataBindRejectLinkButton" ID="DataBindRejectLinkButton">Reject Image</asp:linkbutton>
											</div>
											<asp:image ImageUrl="images/slide.gif" runat="server" OnDataBinding="DataBindInSlideshowIndicator"
												Width="15" Height="17" Visible="False" EnableViewState="False" />
											<div style="PADDING-TOP: 10px">
												<asp:imagebutton ImageUrl="images/edit.gif" runat="server" CommandName="edit" AlternateText="Edit"
													OnDataBinding="DataBindEditButton" Width="12" Height="12" Visible="False" EnableViewState="True" />
												<asp:imagebutton ImageUrl="images/delete.gif" runat="server" CommandName="delete" AlternateText="Delete"
													OnDataBinding="DataBindDeleteButton" Width="12" Height="12" Visible="False" EnableViewState="True" />
												<asp:hyperlink Target="_blank" ImageUrl="images/download.gif" BorderWidth="0" runat="server" OnDataBinding="DataBindDownloadButton"
													Width="12" Height="12" Visible="False" EnableViewState="True" />
												<asp:hyperlink Target="_blank" ImageUrl="images/xml.gif" BorderWidth="0" runat="server" OnDataBinding="DataBindXMLButton"
													Width="12" Height="12" Visible="False" EnableViewState="True" />
												<asp:imagebutton ImageUrl="images/notes.gif" runat="server" OnDataBinding="DataBindNotesButton" Width="12"
													Height="12" Visible="False" EnableViewState="True" CommandName="notes" AlternateText="Notes" />
											</div>
											<asp:linkbutton runat="server" OnDataBinding="DataBindRelatedImagesButton" ID="DataBindRelatedImagesButton" CommandName="related">Related Images</asp:linkbutton>
										</div>
										<div class="oxMetadataOn">
											<asp:placeholder runat="server" OnDataBinding="DataBindImageRecord" EnableViewState="False"></asp:placeholder>
											<asp:panel runat="server" Visible="False">
												<br />
												<b><span runat="server" id="ImageNotesLabelSpan">Image Notes</span></b><br />
												<asp:textbox TextMode="MultiLine" ID="notes" Columns="50" Rows="4" runat="server" OnDataBinding="DataBindImageNotesTextBox"></asp:textbox>
												<br />
												<asp:linkbutton runat="server" OnClick="UpdateImageNotes" ID="UpdateImageNotesButton">Update</asp:linkbutton>
												<asp:linkbutton runat="server" OnClick="CancelImageNotes" ID="CancelImageNotesButton">Cancel</asp:linkbutton>
											</asp:panel>
										</div>
									</li>
								</itemtemplate>
							</asp:repeater>
							</ul>
					</td>
				</tr>
				<tr style="BACKGROUND-COLOR: #eeeeee">
					<td nowrap><asp:button Width="30" ID="FirstPageButton2" runat="server" Text="<<" EnableViewState="False"></asp:button><asp:button Width="30" ID="PrevPageButton2" runat="server" Text="<" EnableViewState="False"></asp:button></td>
					<td nowrap align="center">
						<span id="PageLabel2" runat="server">Page</span>
						<asp:label ID="CurrentPageLabel2" runat="server" Text='<%# CurrentPage %>' EnableViewState="False">
						</asp:label>
						<span id="OfPagesLabel2" runat="server">of</span>
						<asp:label ID="TotalPagesLabel2" runat="server" Text='<%# TotalPages %>' EnableViewState="False">
						</asp:label>&nbsp;(<asp:label ID="NumRecordsLabel2" runat="server" Text='<%# NumRecords %>' EnableViewState="False"></asp:label>
						<span runat="server" id="RecordsFoundLabel2">records found</span>)
					</td>
					<td nowrap align="right">
						<asp:button Width="30" ID="NextPageButton2" runat="server" Text=">" EnableViewState="False"></asp:button><asp:button Width="30" ID="LastPageButton2" runat="server" Text=">>" EnableViewState="False"></asp:button>
					</td>
				</tr>
			</table>
			<asp:panel ID="SlideIconExplanation" runat="server" EnableViewState="False" Visible="False">
<hr width="100%" size="1">
<img height="17" alt="" src="images/slide.gif" width="15"> <span id="ImageAlreadyInSlideshowLabel" runat="server">This 
					image is already in your slideshow</span> " 
<asp:label runat="server" Text="<%# InSlideshowTitle %>"></asp:label>".</asp:panel>
			<div id="SaveSearchDiv" runat="server">
				<br>
				<span id="SaveSearchLabel" runat="server">Save this search as:</span>
				<asp:textbox ID="SaveSearchTextBox" runat="server"></asp:textbox>
				<asp:button ID="SaveSearchButton" runat="server" Text="Save"></asp:button>
			</div>
			<asp:placeholder ID="ScrollToImageNotesPlaceHolder" runat="server" EnableViewState="False"></asp:placeholder>
		</form>
	</body>
</html>
