using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using System.IO;
using Orciid.Core;

namespace Orciid
{
	public class settings : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.CheckBox AllowGuestAccessCheckBox;
		protected System.Web.UI.WebControls.CheckBox AllowGrantingToGuestCheckBox;
		protected System.Web.UI.WebControls.Button GuestAccessUpdateButton;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl PermissionsSubheading;
		protected System.Web.UI.HtmlControls.HtmlAnchor SystemPermissionsLink;
		protected System.Web.UI.HtmlControls.HtmlAnchor SlideshowDefaultPermissionsLink;
		protected System.Web.UI.HtmlControls.HtmlAnchor CollectionDefaultPermissionsLink;
		protected System.Web.UI.HtmlControls.HtmlGenericControl GuestAccessSubheading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl ConfigSettingsSubheading;
		protected System.Web.UI.WebControls.HyperLink EmailImportHyperLink;
		protected System.Web.UI.WebControls.Repeater ConfigSettingsRepeater;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				Properties props = Properties.GetSystemProperties();
				AllowGuestAccessCheckBox.Checked = (props.GetAsInt("allowguest", 0) == 1);
				AllowGrantingToGuestCheckBox.Checked = (props.GetAsInt("allowgrant2guest", 0) == 1);
			}
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			ArrayList keys = new ArrayList();
			if (user != null && user.Administrator)
			{
				Regex removepwds = new Regex("Password=[^;]*;", RegexOptions.IgnoreCase);
				string pwdreplace = GetLocalString(this, "HidePassword", "HIDDEN");
				foreach (string key in Configuration.Instance.GetKeys())
					foreach (string val in Configuration.Instance.GetMultiString(key))
						keys.Add(string.Format("{0}={1}", key, removepwds.Replace(val, "Password=" + pwdreplace + ";")));
				keys.Sort();
				keys.Insert(0, GetLocalString(this, "TemporaryFilePathLabel", "Temporary files path:") + 
					" " + Path.GetTempPath());
				keys.Insert(1, GetLocalString(this, "ConfigFileLocationLabel", "Configuration file located at: ") + 
					" " + Configuration.Instance.ConfigFile);
			}
			else
				keys.Add(GetLocalString(this, "DisplayForAdminOnly", 
					"Configuration settings will only be listed for administrators."));
			ConfigSettingsRepeater.DataSource = keys;
			ConfigSettingsRepeater.DataBind();

			EmailImportHyperLink.Visible = (user != null && user.Administrator);
		}

		public override string GetHighlightedMenuItem()
		{
			return "Management_Settings";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilege(Privilege.ModifyACL, user);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.GuestAccessUpdateButton.Click += new System.EventHandler(this.GuestAccessUpdateButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void GuestAccessUpdateButton_Click(object sender, System.EventArgs e)
		{
			Properties props = Properties.GetSystemProperties();
			props.SetAsInt("allowguest", AllowGuestAccessCheckBox.Checked ? 1 : 0);
			props.SetAsInt("allowgrant2guest", AllowGrantingToGuestCheckBox.Checked ? 1 : 0);
			ShowInformation(GetLocalString(this, "SettingsUpdated", "Settings updated"));
		}
	}
}
