using System;
using System.Data;
using NUnit.Framework;
using DotNetMock.Framework.Data;

namespace DotNetMock.Framework.Tests.Data
{
	/// <summary>
	/// Summary description for MockDataParameterTests.
	/// </summary>
	[TestFixture]
	public class MockDataParameterTests
	{
		private MockDataParameter _mockDataParameter = null;

		[SetUp]
		public void Init()
		{
			Verifier.ResetVerifier();
		}

		[TearDown]
		public void Destroy()
		{
			Verifier.ResetVerifier();
			_mockDataParameter = null;
		}
		
		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void IsNullable()
		{
			_mockDataParameter = new MockDataParameter();

			_mockDataParameter.SetExpectedNullable(true);
			_mockDataParameter.IsNullable = true;
			_mockDataParameter.Verify();

			_mockDataParameter.SetExpectedNullable(false);
			Verifier.ResetVerifier();
			_mockDataParameter.Verify();	
		}

		[Test]
		public void ConstructorNameValueForInt()
		{
			_mockDataParameter = new MockDataParameter("@inpID", 123456);

			_mockDataParameter.SetExpectedValue(123456);
			_mockDataParameter.Verify();
		}

		[Test]
		public void InferTypeMockDataParameter()
		{
			_mockDataParameter = new MockDataParameter("@inpID", 123456);
			
			Assertion.AssertEquals(DbType.Int32, _mockDataParameter.DbType);
		}

		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void ConstructorNameValueForIntInvalid()
		{
			_mockDataParameter = new MockDataParameter("@inpID", "123456");

			_mockDataParameter.SetExpectedValue(123456);
			_mockDataParameter.Verify();
		}

		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void ConstructorNameValue()
		{
			_mockDataParameter = new MockDataParameter("@inpID", "123456");

			_mockDataParameter.SetExpectedName("@inpID");
			_mockDataParameter.SetExpectedValue("123456");

			_mockDataParameter.Verify();

			_mockDataParameter.SetExpectedName("@inpPassword");
			_mockDataParameter.SetExpectedValue("654321");
			
			Verifier.ResetVerifier();
			_mockDataParameter.Verify();
		}

		[Test]
		public void ConstructorNameTypeSourceColumn()
		{
			_mockDataParameter = new MockDataParameter("@inpID", DbType.String, "ID");
			_mockDataParameter.SetExpectedName("@inpID");
			_mockDataParameter.SetExpectedType(DbType.String);
			_mockDataParameter.SetExpectedSourceColumn("ID");
			
			_mockDataParameter.Verify();
			_mockDataParameter.SetExpectedType(DbType.Int32);

			try 
			{
				_mockDataParameter.Verify();
				Assertion.Fail("Should have thrown an exception.");
			}
			catch (AssertionException) 
			{
			}
			_mockDataParameter.SetExpectedSourceColumn("Fake");
			_mockDataParameter.SetExpectedType(DbType.String);
			try 
			{
				_mockDataParameter.Verify();
				Assertion.Fail("Should have thrown an exception.");
			}
			catch (AssertionException)
			{

			}
		}
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void ConstructorNameType()
		{
			_mockDataParameter = new MockDataParameter("@inpID", DbType.String);
			_mockDataParameter.SetExpectedName("@inpID");
			_mockDataParameter.SetExpectedType(DbType.String);
			_mockDataParameter.Verify();
			Verifier.ResetVerifier();
			_mockDataParameter.SetExpectedType(DbType.Int32);
			_mockDataParameter.Verify();			
		}
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void SetValue()
		{
			_mockDataParameter = new MockDataParameter();
			_mockDataParameter.SetExpectedValue("ID");
			_mockDataParameter.SetExpectedType(DbType.String);
			
			_mockDataParameter.Value = "ID";

			_mockDataParameter.Verify();

			_mockDataParameter.SetExpectedType(DbType.Int32);
			Verifier.ResetVerifier();
			_mockDataParameter.Verify();	
		}
	}
}

