using System;
using System.Collections;
using DotNetMock;
using NUnit.Framework;

namespace DotNetMock.Tests
{
	[TestFixture]
	public class AbstractIListExpectationTests : AbstractIListExpectation	
	{
		private ArrayList _actualCollection = null;
		private ArrayList _expectedCollection = null;
		
		[SetUp]
		public void Init()
		{
			_actualCollection = new ArrayList();
			_expectedCollection =  new ArrayList();
		}
		[TearDown]
		public void Destroy()
		{
			_actualCollection = null;
			_expectedCollection = null;
		}
		private class InnerClass
		{
			public string _id = String.Empty;
		}
		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void VerifyFailsForDifferentObjects()
		{
			setGeneralExpectations();
			ActualCollection.Add( new InnerClass() );
			ExpectedCollection.Add( new InnerClass() );
			Verify();
		}
		[Test]
		public void VerifySuccessEqualObjects()
		{
			setGeneralExpectations();
			InnerClass inner = new InnerClass();
			ActualCollection.Add( inner );
			ExpectedCollection.Add( inner );
			Verify();
		}
		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void VerifyFailsDifferentTypesOfObjects()
		{
			setGeneralExpectations();
			ActualCollection.Add( new Exception() );
			ExpectedCollection.Add( new InnerClass() );
			Verify();
		}
		[Test]
		public void VerifyNullValidValues()
		{
			setGeneralExpectations();
			ActualCollection.Add( null );
			ExpectedCollection.Add( null );
			Verify();
			
			ClearActual();
			try
			{
				Verify();
				Assert.Fail( "should throw an exception." );
			} 
			catch {}
		}
		private void setGeneralExpectations() 
		{
			this.HasExpectations = true;
		}
		public override IList ActualCollection
		{
			get
			{
				return _actualCollection;
			}
		}
	
		protected override void CheckImmediateValues(object actual)
		{

		}
	
		public override IList ExpectedCollection
		{
			get
			{
				return _expectedCollection;
			}
		}
	}
}
