using System.Collections;
namespace DotNetMock
{
	/// <summary>
	/// Expectation String Queue implementation. Extends <c>AbstractStaticExpectaion</c>
	/// </summary>
	/// <author>Evhen Khasenevich</author>
	public class ExpectationStringQueue : AbstractStaticExpectation
	{
		private Queue _actualStringQueue = new Queue( );
		private Queue _expectedStringQueue = new Queue( );
		/// <summary>
		/// Default Constructor for ExpectationQueueString.  Set the name for this Expectation
		/// </summary>
		/// <param name="name">Name of this Expectation</param>
		public ExpectationStringQueue( string name ) : base( name )
		{
			ClearActual( );
		}
		/// <summary>
		/// Enqueue/Dequeue Actual strings.
		/// </summary>
		public string Actual
		{
			get
			{
				if ( this._actualStringQueue.Count == 0 )
				{
					return null;
				}
				return ( string )this._actualStringQueue.Dequeue( );
			}
			set
			{
				this._actualStringQueue.Enqueue( value );
				if ( ShouldCheckImmediate )
				{
					Verify( );
				}
			}
		}
		/// <summary>
		/// Enqueue/Dequeue Expected strings.
		/// </summary>
		public string Expected
		{
			get
			{
				if ( this._expectedStringQueue.Count == 0 )
				{
					return null;
				}
				if ( this._expectedStringQueue.Count == 1 )
				{
					this.HasExpectations = false;
				}
				return ( string )this._expectedStringQueue.Dequeue( );
			}
			set
			{
				this._expectedStringQueue.Enqueue( value );
				this.HasExpectations = true;
			}
		}
		/// <summary>
		/// Clears Actual strings.
		/// </summary>
		public override void ClearActual( )
		{
			this._actualStringQueue.Clear( );
		}
		/// <summary>
		/// Clears Expected strings.
		/// </summary>
		public override void ClearExpected( )
		{
			this._expectedStringQueue.Clear( );
			HasExpectations = false;
		}
		/// <summary>
		/// Verifies object
		/// </summary>
		public override void Verify( )
		{
			if ( this.HasExpectations )
			{
				if ( this.ShouldCheckImmediate )
				{
					Assertion.AssertEquals( "String values in the queues are not equal for object " + this.name, this.Expected, this.Actual );
				}
				else
				{
					string expected;
					while ( ( expected = this.Expected ) != null )
					{
						if ( this._actualStringQueue.Count > 0 )
						{
							Assertion.AssertEquals( "String values in the queues are not equal for object " + this.name, expected, this.Actual );
						}
						else
						{
							Assertion.Fail( string.Format( "{0} values left in the expected queue for object {1}: '{2}', ...", this._expectedStringQueue.Count + 1, this.name, expected ) );
						}
					}
					if ( this._actualStringQueue.Count > 0 )
					{
						Assertion.Fail( string.Format( "{0} values left in the actual queue for object {1}: '{2}', ...", this._actualStringQueue.Count, this.name, this.Actual ) );
					}
				}
			}
		}
	}
}