using System;
using System.Threading;
using System.Security;
using System.Security.Permissions;
using System.Security.Principal;

namespace DotNetMock.Examples.Security
{
	/// <summary>
	/// This is a "Sensitive" class that will demonstrate how to use the MockIPrincipal
	/// class for 3 type of security checks: Manually, Imperatively, and Declaratively
	/// </summary>
	public class SensitiveClass
	{
		public SensitiveClass()
		{
		
		}
		public bool CanRunManualCEOCheck() 
		{
			bool allowed = false;
			IPrincipal currentPrincipal = Thread.CurrentPrincipal;
		
			if ( currentPrincipal.Identity.IsAuthenticated ) 
			{
				if ( currentPrincipal.IsInRole( "CEO" ) )
				{
					// Inside of this statment, we would run some code that requires the CEO role.
					// For this example all we are going to do is verify the fact that the caller has
					// the CEO role
					allowed = true;
				}
			}
			return allowed;
		}
		public bool CanRunImperativeCEOCheck()
		{
			bool allowed = false;
			PrincipalPermission CEOPermission = new PrincipalPermission(null, "CEO");
			try 
			{
				CEOPermission.Demand();
				allowed = true;
			}
			catch (SecurityException) {}

			return allowed;
		}
		[PrincipalPermission (SecurityAction.Demand, Role="CEO")]
		public bool CanRunDeclarativeCEOCheck()
		{
			return true;
		}
	}
}
