using System;
using DotNetMock.Framework.Data;
using NUnit.Framework;

namespace DotNetMock.Framework.Tests.Data
{
	[TestFixture]
	public class MockDataSetTests 
	{
		private MockDataSet _mockDS = null;

		[SetUp]
		public void Init() 
		{
			_mockDS = new MockDataSet();
		}
		[TearDown]
		public void Destroy()
		{
			_mockDS = null;
		}

		[Test]
		public void SetRowsValid()
		{
			object[,] rows = new object[2,5];
			rows[0,0] = "temp";
			rows[0,1] = "temp";
			rows[0,2] = "temp";
			rows[0,3] = "temp";
			rows[0,4] = "temp";

			rows[1,0] = "temp";
			rows[1,1] = "temp";
			rows[1,2] = "temp";
			rows[1,3] = "temp";
			rows[1,4] = "temp";

			_mockDS.SetRows( rows );

			Assertion.AssertEquals( "TableCount does not equal.", 1, _mockDS.Tables.Count );
			Assertion.AssertEquals( "RowCount does not equal.", 2, _mockDS.Tables[0].Rows.Count );
			Assertion.AssertEquals( "ColumnCount does not equal.", 5, _mockDS.Tables[0].Columns.Count  );
		}
	}
}
