using System;
using System.Security.Principal;
using NUnit.Framework;
using DotNetMock.Framework.Security.Principal;

namespace DotNetMock.Framework.Tests.Security.Principal
{
	[TestFixture]
	public class MockIPrincipalTests
	{
		private MockIPrincipal mockPrincipal = null;

		[SetUp]
		public void Init() 
		{
			mockPrincipal = new MockIPrincipal();
		}
		[TearDown]
		public void Destroy() 
		{
			mockPrincipal = null;
		}

		[Test]
		public void ExpectedIdentity() 
		{
			IIdentity expectedIdentity = new System.Security.Principal.GenericIdentity("ExpectedIdentity");
			mockPrincipal.SetExpectedIdentity( expectedIdentity );
			Assertion.AssertEquals( "Identities don't equal.", expectedIdentity, mockPrincipal.Identity );
		}
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void ExpectedIdentityFails()
		{
			IIdentity expectedIdentity = new System.Security.Principal.GenericIdentity("ExpectedIdentity" );
			Assertion.AssertEquals( "Identities don't equal", expectedIdentity, mockPrincipal.Identity );
		}
		[Test]
		public void IsInRole() 
		{
			String role = "Manager";
			mockPrincipal.AddExpectedRole( role );
			Assertion.Assert( "Principal is not in role: " + role, mockPrincipal.IsInRole( role ) );
		}
		[Test]
		public void IsInRoleInValid() 
		{
			Assertion.Assert( "Principal is in role!", !mockPrincipal.IsInRole( "Employee" ) );
		}
		[Test]
		public void IsInRoleMultiple() 
		{
			String[] roles = new String[] { "Manager", "CEO" };
			mockPrincipal.AddExpectedRoles( roles );
			
			Assertion.Assert( "Principal is not in role.", mockPrincipal.IsInRole( "CEO" ) );
			Assertion.Assert( "Principal is not in role.", mockPrincipal.IsInRole( "Manager" ) );
		}
		[Test]
		public void IsInRoleCalls() 
		{
			mockPrincipal.SetExpectedIsInRoleCount( 2 );
			mockPrincipal.IsInRole( "" );
			mockPrincipal.IsInRole( "" );
			mockPrincipal.Verify();
		}
	}
}
