#region License
// Copyright (c) 2004 Choy Rim. All rights reserved.
#endregion
#region Imports
using System;
using System.Reflection;
using System.Reflection.Emit;
using DotNetMock.Core;
using NUnit.Framework;

using DotNetMock.TestFramework;
#endregion

namespace DotNetMock.TestFramework.Tests
{
	[TestFixture]
	public class NUnitStubMakerTests 
	{
		[Test] public void Basic() 
		{
			Assembly providerAssembly = Assembly.Load("nunit.framework");
			NUnitStubMaker stubMaker = new NUnitStubMaker(
				providerAssembly, 
				new SystemDynamicLinker()
				);
			StubClassMaker scm = new StubClassMaker();
			Type stubClass = scm.MakeStubClass(typeof(ITestFramework), stubMaker);
			ITestFramework tf = (ITestFramework)
				Activator.CreateInstance(stubClass);
			tf.Assert(true);
			tf.AssertEquals(1, 1);
		}
	}
}
