#region License
// Copyright (c) 2004 Choy Rim. All rights reserved.
#endregion
#region Imports
using System;
using System.Reflection;
using System.Reflection.Emit;

using NUnit.Framework;

using DotNetMock.TestFramework;
#endregion

namespace DotNetMock.TestFramework.Tests
{
	[TestFixture]
	public class StubClassMakerTests 
	{
		static bool CalledMethod1;

		interface ITrivialProvider 
		{
			void Method1();
		}
		class TrivialStubMaker : AbstractStubMaker
		{
			public TrivialStubMaker()
				: base(typeof(StubClassMakerTests))
			{
			}
			public override void ImplementStubMethod(ILGenerator ilg, MethodInfo mi) 
			{
				EmitProviderCall(ilg, "RealMethod1", new Type[0]);
			}
		}
		public static void RealMethod1() 
		{
			CalledMethod1 = true;
		}
		[Test] public void TrivialProviderInterface() 
		{
			StubClassMaker classBuilder = new StubClassMaker();
			TrivialStubMaker tsm = new TrivialStubMaker();
			Type stubClass = classBuilder.MakeStubClass(
				typeof(ITrivialProvider),
				tsm
				);
			ITrivialProvider provider = (ITrivialProvider)
				Activator.CreateInstance(stubClass);
			provider.Method1();
			Assert.IsTrue(CalledMethod1);
		}
		[SetUp]
		public void BeforeEachTest() 
		{
			CalledMethod1 = false;
		}
	}
}
