using System;
using NUnit.Framework;
using DotNetMock;

namespace DotNetMock.Tests
{
	/// <summary>
	/// Summary description for MockObjectTests.
	/// </summary>
	[TestFixture]
	public class MockObjectTests
	{
		private MockObject _mockObject;

		[SetUp]
		public void Init()
		{
			_mockObject = new MockObject();
		}
		[TearDown]
		public void Destroy() 
		{
			_mockObject = null;
		}
		[ExpectedException(typeof(NotImplementedException))]
		public void NotImplemented()
		{
			_mockObject.NotImplemented("Fake Class Name");
		}
		[Test]
		public void MockVerified() 
		{
			Assert.IsTrue( !_mockObject.IsVerified );
			_mockObject.Verify();
			Assert.IsTrue( _mockObject.IsVerified );
		}
	}
}
