namespace DotNetMock 
{
	using System;
	/// <summary>
	/// Expectation Counter implementation.  Extends <c>AbstractExpectation</c>
	/// </summary>
	/// <remarks/>
	public class ExpectationCounter : AbstractStaticExpectation {
		private int _expectedCalls = 0;
    	private int _actualCalls = 0;

		/// <summary>
		/// Default Constructor. Sets the name of this Expectation and Strict to true
		/// </summary>
		/// <param name="name">Name of this Expectation</param>
		public ExpectationCounter(String name) : base(name) {
			Strict = true;
		}
		/// <summary>
		/// Sets Expected counter.
		/// </summary>
		public int Expected
		{
			set
			{
				this._expectedCalls = value;
				this.HasExpectations = true;
			}
		}
		/// <summary>
		/// Resests Actual counter to 0.
		/// </summary>
		public override void ClearActual() {
			this._actualCalls = 0;
		}
		/// <summary>
		/// Resets Expected counter to 0.
		/// </summary>
		public override void ClearExpected() {
			this._expectedCalls = 0;
			HasExpectations = false;
		}
		/// <summary>
		/// Verifies object.
		/// </summary>
		public override void Verify() 
		{
			if ( Strict ) 
			{
				if (this.HasExpectations)
				{
					Assertion.AssertEquals("Did not receive the expected Count for object " + this.name, this._expectedCalls, this._actualCalls);
				}
			} 
			else 
			{
				if (this.HasExpectations)
				{
					Assertion.Assert("Did not receive the expected Count for object " + this.name, this._actualCalls >= this._expectedCalls );
				}
			}
		}
		/// <summary>
		/// Increments Actual counter.
		/// </summary>
		public void Inc()
		{
			this._actualCalls++;
			if (ShouldCheckImmediate) {
				Assertion.Assert(
               this.name + " should not be called more than " + this._expectedCalls + " times",
                this._actualCalls <= this._expectedCalls);
			}
		}
	}
}
	
