using System;
using System.Collections;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class for <see cref="SoundEx"/> class.
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestFieldMapping
	{
		/// <summary>
		/// Test setup
		/// </summary>
		/// <remarks>
		/// Test setup
		/// </remarks>
		[SetUp]
		public void Setup()
		{
			AnonymousUser.User.Activate(null);
		}
		
		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestSimpleMapping()
		{
			string[] source = new string[1];
			source[0] = "Title";
			
			Field[] target = new Field[1];
			target[0] = new Field();
			target[0].Name = "Title";
			
			FieldMapping mapping = new FieldMapping(source, target);
			Assert.AreEqual("Title", mapping.GetMapping("Title"));
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestDublinCoreMapping()
		{
			string[] source = new string[2];
			source[0] = "Title";
			source[1] = "Creator";

			Field[] target = new Field[2];
			target[0] = new Field();
			target[0].Name = "Author";
			target[0].DCElement = "creator";
			target[1] = new Field();
			target[1].Name = "Book title";
			target[1].DCElement = "title";

			FieldMapping mapping = new FieldMapping(source, target);
			Assert.AreEqual("Book title", mapping.GetMapping("Title"));
			Assert.AreEqual("Author", mapping.GetMapping("Creator"));
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestFieldToFieldMapping()
		{
			Field[] source = new Field[2];
			source[0] = new Field();
			source[0].Name = "Architect";
			source[0].DCElement = "creator";
			source[1] = new Field();
			source[1].Name = "Building";
			source[1].DCElement = "title";

			Field[] target = new Field[2];
			target[0] = new Field();
			target[0].Name = "Author";
			target[0].DCElement = "creator";
			target[1] = new Field();
			target[1].Name = "Book title";
			target[1].DCElement = "title";

			FieldMapping mapping = new FieldMapping(source, target);
			Assert.AreEqual("Book title", mapping.GetMapping("Building"));
			Assert.AreEqual("Author", mapping.GetMapping("Architect"));
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestSoundExMapping()
		{
			string[] source = new string[1];
			source[0] = "Titel";
			
			Field[] target = new Field[1];
			target[0] = new Field();
			target[0].Name = "Title";
			
			FieldMapping mapping = new FieldMapping(source, target);
			Assert.AreEqual("Title", mapping.GetMapping("Titel"));
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Test
		/// </remarks>
		[Test]
		public void TestDateFieldMapping()
		{
			string[] source = new string[2];
			source[0] = "Datum";
			source[1] = "DatumIntern";

			Field[] target = new Field[1];
			target[0] = new Field();
			target[0].Name = "Date";
			target[0].Type = FieldType.Date;

			FieldMapping mapping = new FieldMapping(source, target);

			ArrayList targets = new ArrayList(mapping.TargetFields);
			Assert.AreEqual(4, targets.Count);
			Assert.IsTrue(targets.Contains("Date"));
			Assert.IsTrue(targets.Contains("Date::internal"));
			Assert.IsTrue(targets.Contains("Date::start"));
			Assert.IsTrue(targets.Contains("Date::end"));

			mapping.AddMapping("DatumIntern", "Date::internal");
			mapping.AddMapping("Datum", "Date");

			Assert.AreEqual("Date::internal", mapping.GetMapping("DatumIntern"));
			Assert.AreEqual("Date", mapping.GetMappedField("DatumIntern"));
			Assert.AreEqual("Date", mapping.GetMapping("Datum"));
			Assert.AreEqual("Date", mapping.GetMappedField("Datum"));
		}
	}
}
