using System;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test class for <see cref="IPAddress"/> class.
	/// </summary>
	/// <remarks>
	/// This class contains test methods.  It does not need to be compiled into the package.
	/// </remarks>
	[TestFixture]
	public class TestIPAddress
	{
		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Tests <see cref="IPAddress.IsValid"/> method.
		/// </remarks>
		[Test]
		public void IPAddressValidity()
		{
			// valid IP addresses
			Assert.IsTrue(IPAddress.IsValid("127.0.0.1"));
			Assert.IsTrue(IPAddress.IsValid("255.255.255.255"));
			Assert.IsTrue(IPAddress.IsValid("0.0.0.0"));

			// invalid IP addresses
			Assert.IsFalse(IPAddress.IsValid("hello"));
			Assert.IsFalse(IPAddress.IsValid("123456"));
			Assert.IsFalse(IPAddress.IsValid("0.0.0"));
			Assert.IsFalse(IPAddress.IsValid("256.0.0.1"));
			Assert.IsFalse(IPAddress.IsValid("127.0.0.0.1"));
			Assert.IsFalse(IPAddress.IsValid("123.456.789.012"));
		}

		/// <summary>
		/// Test
		/// </summary>
		/// <remarks>
		/// Tests <see cref="IPAddress.IsInSubnet"/> method.
		/// </remarks>
		[Test]
		public void IPAddressSubnet()
		{
			// valid subnet checks
			Assert.IsTrue(IPAddress.IsInSubnet("127.0.0.1", "127.0.0.1", "255.255.255.255"));
			Assert.IsTrue(IPAddress.IsInSubnet("127.0.0.1", "127.0.0.0", "255.255.255.0"));
			Assert.IsTrue(IPAddress.IsInSubnet("134.126.99.65", "134.126.0.0", "255.255.0.0"));
			Assert.IsTrue(IPAddress.IsInSubnet("134.126.99.65", "134.126.99.64", "255.255.255.192"));

			// invalid subnet checks
			Assert.IsFalse(IPAddress.IsInSubnet("256.0.0.1", "127.0.0.1", "255.255.255.255"));
			Assert.IsFalse(IPAddress.IsInSubnet("127.0.0.1", "256.0.0.1", "255.255.255.255"));
			Assert.IsFalse(IPAddress.IsInSubnet("127.0.0.1", "127.0.0.1", "256.255.255.255"));
			
			// addresses not in subnet
			Assert.IsFalse(IPAddress.IsInSubnet("127.0.0.1", "127.0.0.0", "255.255.255.255"));
			Assert.IsFalse(IPAddress.IsInSubnet("134.126.99.65", "134.126.0.0", "255.255.255.0"));
			Assert.IsFalse(IPAddress.IsInSubnet("134.126.99.33", "134.126.99.64", "255.255.255.192"));
		}
	}
}
