using System;
using System.Collections;
using NUnit.Framework;

namespace Orciid.Core
{
	/// <summary>
	/// Test fixture
	/// </summary>
	[TestFixture]
	public class TestQuery
	{
		/// <summary>
		/// Test
		/// </summary>
		[Test]
		public void TestArrayListParamExpansion()
		{
			ArrayList list = new ArrayList();
			list.Add(1);
			list.Add(2);
			list.Add(3);
			MySQLDBConnection conn = new MySQLDBConnection(null, false);
			string sql = "SELECT * FROM test WHERE ID IN {ids}";
			Query query = new Query(conn, sql);
			query.AddParam("ids", list);
			string result = query.SQL;
			Assert.AreEqual("SELECT * FROM test WHERE ID IN (1,2,3)", result);
		}

		/// <summary>
		/// Test
		/// </summary>
		[Test]
		public void TestArrayParamExpansion()
		{
			int[] list = new int[] { 1, 2, 3 };
			MySQLDBConnection conn = new MySQLDBConnection(null, false);
			string sql = "SELECT * FROM test WHERE ID IN {ids}";
			Query query = new Query(conn, sql);
			query.AddParam("ids", list);
			string result = query.SQL;
			Assert.AreEqual("SELECT * FROM test WHERE ID IN (1,2,3)", result);
		}
	}
}
