using System;
using NUnit.Framework;

namespace Orciid.Core.Util
{
	/// <summary>
	/// Test class
	/// </summary>
	/// <remarks>
	/// Test cases for <see cref="Initialization"/> class.
	/// </remarks>
	[TestFixture]
	public class TestInitialization
	{
		static bool initran;
		static bool causeexception;
		static bool alwaysfalse;

		/// <summary>
		/// Test setup
		/// </summary>
		[SetUp]
		public void Setup()
		{
			initran = false;
			causeexception = false;
			alwaysfalse = false;
		}

		/// <summary>
		/// Test
		/// </summary>
		[Test]
		public void RunInitialization()
		{
			Assert.IsFalse(initran);
			Initialization.Run(true);
			Assert.IsTrue(initran);
			Assert.IsFalse(alwaysfalse);
		}

		/// <summary>
		/// Test
		/// </summary>
		[Test]
		[ExpectedException(typeof(InitializationException))]
		public void CauseException()
		{
			Assert.IsFalse(initran);
			causeexception = true;
			Initialization.Run(true);
			Assert.IsTrue(initran);
			Assert.IsFalse(alwaysfalse);
		}

		/// <summary>
		/// Test helper method
		/// </summary>
		[Initialize(Test = true)]
		public static void Initialize()
		{
			initran = true;
			if (causeexception)
				throw new Exception();
		}

		/// <summary>
		/// Test helper method
		/// </summary>
		[Initialize]
		public static void ThisShouldNotGetCalled()
		{
			alwaysfalse = true;
		}
	}
}
