using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using imagemanager.localhost;

namespace imagemanager
{
	/// <summary>
	/// Summary description for CollectionSelectForm.
	/// </summary>
	public class CollectionSelectForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label collectionLabel;
		private System.Windows.Forms.ComboBox collectionComboBox;
		private System.Windows.Forms.Button selectButton;
		private System.Windows.Forms.Button cancelButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private CollectionInfo[] info = null;

		public CollectionInfo GetCollectionInfo()
		{
			if (info != null)
				foreach (CollectionInfo i in info)
					if ((string)collectionComboBox.SelectedItem == i.title)
						return i;
			return null;
		}

		public CollectionSelectForm(ImageManager manager, string token)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			try
			{
				info = manager.GetCollectionInfo(token);
				if (info != null && info.Length > 0)
				{
					collectionComboBox.Items.Clear();
					foreach (CollectionInfo i in info)
						collectionComboBox.Items.Add(i.title);
					collectionComboBox.SelectedIndex = 0;
					selectButton.Enabled = true;
				}
				else
					throw new Exception();
			}
			catch 
			{
				collectionComboBox.Items.Clear();
				collectionComboBox.Items.Add("[No collections available]");
				selectButton.Enabled = false;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.collectionLabel = new System.Windows.Forms.Label();
			this.collectionComboBox = new System.Windows.Forms.ComboBox();
			this.selectButton = new System.Windows.Forms.Button();
			this.cancelButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// collectionLabel
			// 
			this.collectionLabel.Location = new System.Drawing.Point(8, 8);
			this.collectionLabel.Name = "collectionLabel";
			this.collectionLabel.Size = new System.Drawing.Size(64, 16);
			this.collectionLabel.TabIndex = 0;
			this.collectionLabel.Text = "Collection:";
			// 
			// collectionComboBox
			// 
			this.collectionComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.collectionComboBox.Location = new System.Drawing.Point(72, 8);
			this.collectionComboBox.Name = "collectionComboBox";
			this.collectionComboBox.Size = new System.Drawing.Size(320, 21);
			this.collectionComboBox.Sorted = true;
			this.collectionComboBox.TabIndex = 1;
			// 
			// selectButton
			// 
			this.selectButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.selectButton.Location = new System.Drawing.Point(312, 48);
			this.selectButton.Name = "selectButton";
			this.selectButton.TabIndex = 2;
			this.selectButton.Text = "Select";
			// 
			// cancelButton
			// 
			this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cancelButton.Location = new System.Drawing.Point(224, 48);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.TabIndex = 3;
			this.cancelButton.Text = "Cancel";
			// 
			// CollectionSelectForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(402, 85);
			this.Controls.Add(this.cancelButton);
			this.Controls.Add(this.selectButton);
			this.Controls.Add(this.collectionComboBox);
			this.Controls.Add(this.collectionLabel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "CollectionSelectForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Select Collection";
			this.ResumeLayout(false);

		}
		#endregion

	}
}
