using System;

namespace DotNetMock.Examples.Dynamic
{
	public class DefaultWeatherRandom : IWeatherRandom
	{
		public const double CHANCE_OF_RAIN = 0.2;
		public const double MIN_TEMPERATURE = 20;
		public const double MAX_TEMPERATURE = 30;
		
		private const double TEMPERATURE_RANGE = (MAX_TEMPERATURE-MIN_TEMPERATURE);
    
		private System.Random rng;
    
		public DefaultWeatherRandom( System.Random rng ) 
		{
			this.rng = rng;
		}
		
		public bool NextIsRaining() 
		{
			return rng.NextDouble() < CHANCE_OF_RAIN;
		}
		
		public double NextTemperature() 
		{
			return MIN_TEMPERATURE + rng.NextDouble() * TEMPERATURE_RANGE;
		}
	}
}
