using System;
using NUnit.Framework;
using DotNetMock.Framework.Data;

namespace DotNetMock.Framework.Tests.Data
{
	[TestFixture]
	public class MockDbDataAdapterTests 
	{
		private MockDbDataAdapter _mockAdapter = null;

		[SetUp]
		public void Init() 
		{
			_mockAdapter = new MockDbDataAdapter();
		}
		[TearDown]
		public void Destroy()
		{
			Verifier.ResetVerifier();
			_mockAdapter = null;
		}

		[Test]
		public void FillCountValid()
		{
			_mockAdapter.SetExpectedFillCalls( 2 );
			_mockAdapter.Fill(new MockDataSet());
			_mockAdapter.Fill(new MockDataSet());
			_mockAdapter.Verify();
		}
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void FillCountInValid()
		{
			_mockAdapter.SetExpectedFillCalls( 2 );
			_mockAdapter.Fill(new MockDataSet());
			_mockAdapter.Verify();
		}
	}
}
