#region License
// Copyright (c) 2004, 2005 Griffin Caprio & Choy Rim. All rights reserved.
#endregion
#region Imports
using System;
using System.Data;
using System.Data.Common;

using DotNetMock;
#endregion

namespace DotNetMock.Framework.Data
{
	/// <summary>
	/// Mock <see cref="DbDataAdapter"/>.
	/// </summary>
	/// <author>Griffin Caprio</author>
	public class MockDbDataAdapter : DbDataAdapter, IMockObject, IDbDataAdapter
	{
		private ExpectationCounter _expectedFillCalls = new ExpectationCounter("MockDbDataAdapter.ExpectedFillCalls");
		private DataSet _expectedDataSet = null;

		private string _name = "";
		private bool _isVerified = false;
		private MockCommand _insertCommand;
		private MockCommand _updateCommand;
		private MockCommand _deleteCommand;
		private MockCommand _selectCommand;

		#region Public Constructors
		/// <summary>
		/// Create mock <see cref="DbDataAdapter"/>.
		/// </summary>
		public MockDbDataAdapter()
		{
			this._name = "MockDbDataAdapter";
		}
		/// <summary>
		/// Create mock <see cref="DbDataAdapter"/>.
		/// </summary>
		public MockDbDataAdapter( IDbCommand selectCommand )
		{
			_selectCommand = (MockCommand) selectCommand;
		
		}
		/// <summary>
		/// Create mock <see cref="DbDataAdapter"/>.
		/// </summary>
		public MockDbDataAdapter( IDbCommand selectCommand, string selectConnectionString )
		{
			_selectCommand = (MockCommand) selectCommand;

		}
		/// <summary>
		/// Create mock <see cref="DbDataAdapter"/>.
		/// </summary>
		public MockDbDataAdapter( string selectCommandText, IDbConnection selectConnection )
		{

		}
		#endregion

		#region Mock Methods
		/// <summary>
		/// Set the expected number of Fill calls.
		/// </summary>
		/// <param name="calls">number of expected Fill calls</param>
		public void SetExpectedFillCalls( int calls )
		{
			_expectedFillCalls.Expected = calls;
		}
		/// <summary>
		/// Set the <see cref="DataSet"/> that will be returned by
		/// the Fill call.
		/// </summary>
		/// <param name="dataSet">expected <see cref="DataSet"/></param>
		public void SetExpectedDataSet( DataSet dataSet )
		{
			_expectedDataSet = dataSet;
		}
		#endregion

		#region Implementation of IMockObject
		/// <summary>
		/// <see cref="IMockObject.NotImplemented"/>
		/// </summary>
		/// <param name="methodName">name of method not implemented</param>
		public void NotImplemented(string methodName)
		{
			throw new NotImplementedException( methodName + " is currently not implemented." );
		}
		/// <summary>
		/// Name of this mock object.
		/// </summary>
		public string MockName
		{
			get
			{
				return _name;
			}
			set
			{
				_name = value;
			}
		}
		#endregion

		#region Implementation of IVerifiable
		/// <summary>
		/// <see cref="IVerifiable.Verify"/>
		/// </summary>
		public void Verify()
		{
			Verifier.Verify( this );
			_isVerified = true;
		}
		#endregion

		#region Implementation of DbDataAdapter
		/// <summary>
		/// <see cref="DbDataAdapter.CreateRowUpdatingEvent"/>
		/// </summary>
		protected override System.Data.Common.RowUpdatedEventArgs CreateRowUpdatedEvent(System.Data.DataRow dataRow, System.Data.IDbCommand command, System.Data.StatementType statementType, System.Data.Common.DataTableMapping tableMapping)
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.CreateRowUpdatingEvent"/>
		/// </summary>
		protected override System.Data.Common.RowUpdatingEventArgs CreateRowUpdatingEvent(System.Data.DataRow dataRow, System.Data.IDbCommand command, System.Data.StatementType statementType, System.Data.Common.DataTableMapping tableMapping)
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.OnRowUpdating"/>
		/// </summary>
		protected override void OnRowUpdated(System.Data.Common.RowUpdatedEventArgs value)
		{
		
		}
		/// <summary>
		/// <see cref="DbDataAdapter.OnRowUpdating"/>
		/// </summary>
		protected override void OnRowUpdating(System.Data.Common.RowUpdatingEventArgs value)
		{
		
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		protected override int Fill(System.Data.DataTable dataTable, System.Data.IDataReader dataReader)
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		protected override int Fill(System.Data.DataSet dataSet, string srcTable, System.Data.IDataReader dataReader, int startRecord, int maxRecords)
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		protected override int Fill(System.Data.DataTable dataTable, System.Data.IDbCommand command, System.Data.CommandBehavior behavior)
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		protected override int Fill(System.Data.DataSet dataSet, int startRecord, int maxRecords, string srcTable, System.Data.IDbCommand command, System.Data.CommandBehavior behavior)
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		public override int Fill(System.Data.DataSet dataSet)
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		public new int Fill( System.Data.DataSet dataSet, string srcTable )
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		public new int Fill( System.Data.DataSet dataSet, int startRecord, int maxRecords, string srcTable )
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Fill"/>
		/// </summary>
		public new int Fill( DataTable dataTable )
		{
			innerExecute();
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Dispose"/>
		/// </summary>
		protected override void Dispose(bool disposing)
		{
		
		}
		/// <summary>
		/// <see cref="DbDataAdapter.FillSchema"/>
		/// </summary>
		protected override System.Data.DataTable FillSchema(System.Data.DataTable dataTable, System.Data.SchemaType schemaType, System.Data.IDbCommand command, System.Data.CommandBehavior behavior)
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.FillSchema"/>
		/// </summary>
		protected override System.Data.DataTable[] FillSchema(System.Data.DataSet dataSet, System.Data.SchemaType schemaType, System.Data.IDbCommand command, string srcTable, System.Data.CommandBehavior behavior)
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.FillSchema"/>
		/// </summary>
		protected new System.Data.DataTable[] FillSchema(System.Data.DataSet dataSet, System.Data.SchemaType schemaType, string srcTable )
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.FillSchema"/>
		/// </summary>
		public override System.Data.DataTable[] FillSchema(System.Data.DataSet dataSet, System.Data.SchemaType schemaType)
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.FillSchema"/>
		/// </summary>
		public new System.Data.DataTable FillSchema(System.Data.DataTable dataTable, System.Data.SchemaType schemaType)
		{
			return null;
		}
		private void innerExecute()
		{
			_expectedFillCalls.Inc();
		}
		/// <summary>
		/// <see cref="DbDataAdapter.GetFillParameters"/>
		/// </summary>
		public override System.Data.IDataParameter[] GetFillParameters()
		{
			return null;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.OnFillError"/>
		/// </summary>
		protected override void OnFillError(System.Data.FillErrorEventArgs value)
		{
		
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Update"/>
		/// </summary>
		protected override int Update(System.Data.DataRow[] dataRows, System.Data.Common.DataTableMapping tableMapping)
		{
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Update"/>
		/// </summary>
		public new int Update(System.Data.DataSet dataSet, string srcTable)
		{
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Update"/>
		/// </summary>
		public new int Update(System.Data.DataTable dataTable)
		{
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Update"/>
		/// </summary>
		public new int Update(System.Data.DataRow[] dataRows)
		{
			return 0;
		}
		/// <summary>
		/// <see cref="DbDataAdapter.Update"/>
		/// </summary>
		public override int Update(System.Data.DataSet dataSet)
		{
			return 0;
		}
		#endregion

		#region IDbDataAdapter Members
		/// <summary>
		/// <see cref="IDbDataAdapter.UpdateCommand"/>
		/// </summary>
		public IDbCommand UpdateCommand
		{
			get
			{
				return (IDbCommand) _updateCommand;
			}
			set
			{
				_updateCommand = (MockCommand) value;
			}
		}
		/// <summary>
		/// <see cref="IDbDataAdapter.SelectCommand"/>
		/// </summary>
		public IDbCommand SelectCommand
		{
			get
			{
				return (IDbCommand) _selectCommand;
			}
			set
			{
				_selectCommand = (MockCommand) value;
			}
		}
		/// <summary>
		/// <see cref="IDbDataAdapter.DeleteCommand"/>
		/// </summary>
		public IDbCommand DeleteCommand
		{
			get
			{
				return (IDbCommand) _deleteCommand;
			}
			set
			{
				_deleteCommand = (MockCommand) value;
			}
		}
		/// <summary>
		/// <see cref="IDbDataAdapter.InsertCommand"/>
		/// </summary>
		public IDbCommand InsertCommand
		{
			get
			{
				return (IDbCommand) _insertCommand;
			}
			set
			{
				_insertCommand = (MockCommand) value;
			}
		}
		#endregion

		#region IDataAdapter Members
	

		#endregion

		#region IVerifiable Members
		/// <summary>
		/// <see cref="IVerifiable.IsVerified"/>
		/// </summary>
		public bool IsVerified
		{
			get
			{
				return _isVerified;
			}
		}
		#endregion
	}
}
