#region License
// Copyright (c) 2004 Choy Rim. All rights reserved.
#endregion
#region Imports
using DotNetMock.Dynamic;
using NUnit.Framework;

using DotNetMock.Dynamic.Predicates;
#endregion

namespace DotNetMock.Tests.Dynamic
{
	[TestFixture]
	public class AssignTests 
	{
		[Test] public void SetAndRequireEqualImplied() 
		{
			object av = new Assign("hello").AndRequire("goodbye");
			object pv = "goodbye";
			IPredicate predicate = av as IPredicate;
			Assert.IsNotNull(predicate);
			Assert.IsTrue(predicate.Eval(pv));
			IArgumentMutator am = av as IArgumentMutator;
			am.Mutate(ref pv);
			Assert.AreEqual("hello", (string) pv);
		}
		[Test] public void SetAndRequireEqual() 
		{
			object av = new Assign("hello").AndRequire(new IsEqual("goodbye"));
			object pv = "goodbye";
			IPredicate predicate = av as IPredicate;
			Assert.IsNotNull(predicate);
			Assert.IsTrue(predicate.Eval(pv));
			IArgumentMutator am = av as IArgumentMutator;
			am.Mutate(ref pv);
			Assert.AreEqual("hello", (string) pv);
		}
		[Test] public void SetString() 
		{
			Assign av = new Assign("hello");
			object pv = "goodbye";
			av.Mutate(ref pv);
			Assert.AreEqual("hello", (string) pv);
		}
		[Test] public void SetInt32() 
		{
			Assign av = new Assign(123);
			object pv = 234;
			av.Mutate(ref pv);
			Assert.AreEqual(123, (int) pv);
		}
		[Test] public void SetInt32OfArray() 
		{
			Assign av = new Assign(123);
			object[] pvs = new object[] { 234 };
			av.Mutate(ref pvs[0]);
			Assert.AreEqual(123, (int) pvs[0]);
		}
	}
}
