#region License
// Copyright (c) 2004 Griffin Caprio & Choy Rim. All rights reserved.
#endregion
#region Imports
using System;
using System.Reflection;
using DotNetMock.Dynamic.Predicates;
using NUnit.Framework;
using DotNetMock.Dynamic;
#endregion

namespace DotNetMock.Tests.Dynamic
{
	[TestFixture]
	public class DynamicOrderedMockTests : AbstractDynamicMockTests
	{
		protected override IDynamicMock newDynamicMock(Type type, string name)
		{
			return new DynamicOrderedMock(type, name);
		}
		protected override IDynamicMock newDynamicMock(Type type)
		{
			return new DynamicOrderedMock(type);
		}
		protected override IDynamicMock newDynamicMock(string name)
		{
			return new DynamicOrderedMock(name);
		}

		[Test]
		[ExpectedException(
			 typeof(AssertionException),
			 "Unexpected call myMethod3()"
			 )]
		public void CallMoreMethodsThanExpected() 
		{
			mock.Expect("myMethod1");
			mock.Expect("myMethod2");
			mock.Call(myMethod1);
			mock.Call(myMethod2);
			mock.Call(myMethod3);
			mock.Verify();
		}

		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void CallMultipleMethodsInWrongOrder() 
		{
			mock.Expect("myMethod1");
			mock.Expect("myMethod2");
			mock.Expect("myMethod3");
			mock.Call(myMethod1);
			mock.Call(myMethod3);
			mock.Call(myMethod2);
			mock.Verify();
		}

		[Test]		
		public void CustomDynamicMock()
		{
			IDynamicMock mock = new CustomMock(typeof(IBlah));
			IBlah blah = (IBlah)mock.Object;
			Assert.AreEqual("CUSTOM", blah.DoStuff("hello"));
			mock.Verify();
		}

		private class CustomMock : DynamicOrderedMock
		{
			public CustomMock(Type t) : base(t) {}
			
			public override object Call(MethodInfo mi, params object[] args)
			{
				return "CUSTOM";
			}
		}
	}

}
