#region License
// Copyright (c) 2004 Griffin Caprio & Choy Rim. All rights reserved.
// until we agree on which open-source licnese to use.
#endregion
#region Imports
using System;
using System.Collections;
using System.Reflection.Emit;
using DotNetMock.Dynamic.Generate;
using NUnit.Framework;
#endregion

namespace DotNetMock.Tests.Dynamic.Generate
{
	[TestFixture]
	public class ILUtilsTests
	{
		[Test] public void LdindOpcodes() 
		{
			Assert.AreEqual( OpCodes.Ldind_I1, ILUtils.GetLdindOpCodeForType(typeof(sbyte)) );
			Assert.AreEqual( OpCodes.Ldind_I2, ILUtils.GetLdindOpCodeForType(typeof(short)) );
			Assert.AreEqual( OpCodes.Ldind_I4, ILUtils.GetLdindOpCodeForType(typeof(int)) );
			Assert.AreEqual( OpCodes.Ldind_I8, ILUtils.GetLdindOpCodeForType(typeof(long)) );
			Assert.AreEqual( OpCodes.Ldind_U1, ILUtils.GetLdindOpCodeForType(typeof(byte)) );
			Assert.AreEqual( OpCodes.Ldind_U2, ILUtils.GetLdindOpCodeForType(typeof(ushort)) );
			Assert.AreEqual( OpCodes.Ldind_U4, ILUtils.GetLdindOpCodeForType(typeof(uint)) );
			Assert.AreEqual( OpCodes.Ldind_I8, ILUtils.GetLdindOpCodeForType(typeof(ulong)) );
			Assert.AreEqual( OpCodes.Ldind_R4, ILUtils.GetLdindOpCodeForType(typeof(float)) );
			Assert.AreEqual( OpCodes.Ldind_R8, ILUtils.GetLdindOpCodeForType(typeof(double)) );
			Assert.AreEqual( OpCodes.Ldind_U2, ILUtils.GetLdindOpCodeForType(typeof(char)) );
			Assert.AreEqual( OpCodes.Ldind_I1, ILUtils.GetLdindOpCodeForType(typeof(bool)) );
			Assert.AreEqual( OpCodes.Ldobj,    ILUtils.GetLdindOpCodeForType(typeof(Guid)) );
			Assert.AreEqual( OpCodes.Ldind_Ref, ILUtils.GetLdindOpCodeForType(typeof(object)) );
		}
		[Test] public void StindOpcodes() 
		{
			Assert.AreEqual( OpCodes.Stind_I1, ILUtils.GetStindOpCodeForType(typeof(sbyte)) );
			Assert.AreEqual( OpCodes.Stind_I2, ILUtils.GetStindOpCodeForType(typeof(short)) );
			Assert.AreEqual( OpCodes.Stind_I4, ILUtils.GetStindOpCodeForType(typeof(int)) );
			Assert.AreEqual( OpCodes.Stind_I8, ILUtils.GetStindOpCodeForType(typeof(long)) );
			Assert.AreEqual( OpCodes.Stind_I1, ILUtils.GetStindOpCodeForType(typeof(byte)) );
			Assert.AreEqual( OpCodes.Stind_I2, ILUtils.GetStindOpCodeForType(typeof(ushort)) );
			Assert.AreEqual( OpCodes.Stind_I4, ILUtils.GetStindOpCodeForType(typeof(uint)) );
			Assert.AreEqual( OpCodes.Stind_I8, ILUtils.GetStindOpCodeForType(typeof(ulong)) );
			Assert.AreEqual( OpCodes.Stind_R4, ILUtils.GetStindOpCodeForType(typeof(float)) );
			Assert.AreEqual( OpCodes.Stind_R8, ILUtils.GetStindOpCodeForType(typeof(double)) );
			Assert.AreEqual( OpCodes.Stind_I2, ILUtils.GetStindOpCodeForType(typeof(char)) );
			Assert.AreEqual( OpCodes.Stind_I1, ILUtils.GetStindOpCodeForType(typeof(bool)) );
			Assert.AreEqual( OpCodes.Stobj,    ILUtils.GetStindOpCodeForType(typeof(Guid)) );
			Assert.AreEqual( OpCodes.Stind_Ref, ILUtils.GetStindOpCodeForType(typeof(object)) );
		}
	}
}
