using NUnit.Framework;
using DotNetMock;

namespace DotNetMock.Tests
{
	[TestFixture]
	public class ExpectationStringTests
	{
		ExpectationString _expectationString = null;

		[SetUp]
		public void SetUp()
		{
			_expectationString = new ExpectationString("ExpectationString");
		}
		
		[TearDown]
		public void TearDown()
		{
			_expectationString = null;
		}

		[Test]
		public void SetActual()
		{
			string test1 = "Mock Objects are Cool";

			Assert.IsNull(_expectationString.Actual);
			_expectationString.Actual = test1;
			Assert.IsNotNull(_expectationString.Actual);
			Assert.AreEqual(test1, _expectationString.Actual);
			_expectationString.ClearActual();
			Assert.IsNull(_expectationString.Actual);
		}

		[Test]
		public void SetExpected()
		{
			string test2 = "Unit Testing helps code.";

			Assert.IsNull(_expectationString.Expected);
			_expectationString.Expected = test2;
			Assert.IsNotNull(_expectationString.Expected);
			Assert.AreEqual(test2, _expectationString.Expected);
			_expectationString.ClearExpected();
			Assert.IsNull(_expectationString.Expected);
		}

		[Test]
		public void HasExpectations()
		{
			string test3 = "Sourceforge is nice.";

			Assert.IsNull(_expectationString.Expected);
			_expectationString.Expected = test3;
			Assert.IsNotNull(_expectationString.Expected);
			Assert.AreEqual(test3, _expectationString.Expected);
			Assert.IsTrue(_expectationString.HasExpectations);
			
			test3 = null;
		}

		[Test]
		public void Verify()
		{
			string test4 = "Mock Objects are cool.";
			string test5 = "Sourceforge is nice.";
			string test6 = "Mock Objects are cool.";

			_expectationString.Actual = test4;
			_expectationString.Expected = test5;

			try 
			{
				_expectationString.Verify();
			}
			catch 
			{
			}
				
			_expectationString.Expected = test6;
			_expectationString.Verify();

			test4 = null;
			test5 = null;
			test6 = null;
		}

		[Test]
		public void FailureMode()
		{
			string test7 = "";

			_expectationString.Expected = test7;

			Assert.IsTrue(_expectationString.HasExpectations);
			Assert.IsTrue(!(_expectationString.ShouldCheckImmediate));
			_expectationString.VerifyImmediate = true;
			Assert.IsTrue(_expectationString.ShouldCheckImmediate);
			
			test7 = null;
		}

		[Test]
		public void ClearActual()
		{
			string test8 = "Testing";

			Assert.IsNull(_expectationString.Actual);
			_expectationString.Actual = test8;
			Assert.IsNotNull(_expectationString.Actual);
			_expectationString.ClearActual();
			Assert.IsNull(_expectationString.Actual);

			test8 = null;
		}

		[Test]
		public void ClearExpected()
		{
			string test9 = "Testing";

			Assert.IsNull(_expectationString.Expected);
			_expectationString.Expected = test9;
			Assert.IsNotNull(_expectationString.Expected);
			_expectationString.ClearExpected();
			Assert.IsNull(_expectationString.Expected);

			test9 = null;
		}
		[Test]
		public void ShouldCheckImmediate()
		{
			string test10 = "Testing";
			_expectationString.Expected = test10;
			_expectationString.VerifyImmediate = true;
			_expectationString.Actual = test10;
		}
	}
}
