using System;
using DotNetMock;
using NUnit.Framework;

namespace DotNetMock.Tests
{
	/// <summary>
	/// Summary description for ExpectationTypeTests.
	/// </summary>
	[TestFixture]
	public class ExpectationTypeTests
	{
		private ExpectationType _expectationType = null;
		
		[SetUp]
		public void SetUp() 
		{
			_expectationType = new ExpectationType("ExpectationValue");
		}
		
		[TearDown]
		public void TearDown() 
		{
			_expectationType = null;
		}
		
		[Test]
		public void SetActual() 
		{	
			Type type1 = typeof(string);

			Assert.IsNull(_expectationType.Actual);
			_expectationType.Actual = type1;
			Assert.AreEqual(type1, _expectationType.Actual);
			
			type1 = null;
		}

		[Test]
		public void SetExpected() 
		{
			Type type2 = typeof(int);

			Assert.IsNull(_expectationType.Expected);
			_expectationType.Expected = type2;
			Assert.AreEqual(type2, _expectationType.Expected);
			
			type2 = null;
		}
		
		[Test]
		public void HasExpectations() 
		{
			Type type3 = typeof(float);
			
			_expectationType.Expected = type3;
			Assert.IsTrue(_expectationType.HasExpectations);
			
			type3 = null;
		}

		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void Verify()
		{
			Type type1 = typeof(string);
			Type type2 = typeof(int);
			Type type3 = typeof(string);

			_expectationType.Actual = type1 ;
			_expectationType.Expected = type2 ;

			_expectationType.Verify();
			
			_expectationType.Expected = type3 ;
			_expectationType.Verify();

		}
		
		[Test]
		public void FailureMode()
		{
			Type type4 = typeof(double);

			_expectationType.Expected = type4;

			Assert.IsTrue(_expectationType.HasExpectations);
			Assert.IsTrue(!(_expectationType.ShouldCheckImmediate));
			_expectationType.VerifyImmediate = true;
			Assert.IsTrue(_expectationType.ShouldCheckImmediate);
			
			type4 = null;
		}

		[Test]
		public void ClearActual()
		{
			Type type5 = typeof(string);

			Assert.IsNull(_expectationType.Actual);
			_expectationType.Actual = type5;
			Assert.IsNotNull(_expectationType.Actual);
			_expectationType.ClearActual();
			Assert.IsNull(_expectationType.Actual);
			
			type5 = null;
		}
		
		[Test]
		public void ClearExpected()
		{
			Type type6 = typeof(string);

			Assert.IsNull(_expectationType.Expected);
			_expectationType.Expected = type6;
			Assert.IsNotNull(_expectationType.Expected);
			Assert.IsTrue(_expectationType.HasExpectations);
			_expectationType.ClearExpected();
			Assert.IsNull(_expectationType.Expected);
			
			type6 = null;
		}
		
		[Test]
		public void NullValues()
		{
			_expectationType.ExpectNothing();
			_expectationType.ClearActual();
			_expectationType.Verify();
		}
		[Test]
		public void ShouldCheckImmediate()
		{
			_expectationType.Expected = typeof(string);
			_expectationType.VerifyImmediate = true;
			_expectationType.Actual = typeof(string);
		}
		[Test]
			public void NoExpectations()
		{
			_expectationType.Verify();
		}
	}
}
