using NUnit.Framework;
using DotNetMock;

namespace DotNetMock.Tests
{
	/// <summary>
	/// Summary description for Null Class.
	/// </summary>
	[TestFixture]
	public class NullTests
	{
		private NullObject _null = null;
		
		[SetUp]
		public void Init() {
			_null = new NullObject();
		}
		
		[TearDown]
		public void Destroy() {
			_null = null;
		}
		
		[Test]
		public void NullObjectMethods() {
			Assert.AreEqual("null", _null.ToString());
			_null.Name = "Null Object";
			Assert.AreEqual("Null Object", _null.ToString());
			NullObject null2 = new NullObject();
			int int1 = 3;
			Assert.IsTrue(!_null.Equals(int1));
			Assert.IsTrue(_null.Equals(null2));
		}
		[Test]
		public void NullHashCode()
		{
			Assert.AreEqual("null".GetHashCode(), _null.GetHashCode());
		}
		[Test]
			public void NullName()
		{
			_null = new NullObject("null");
			Assert.AreEqual( "null", _null.Name );
		}
	}
}
