namespace DotNetMock.Tests
{
	using System;
	using System.Collections;
	using NUnit.Framework;
	
	[TestFixture]
	public class ReturnValueTest
	{
		private ReturnValue r;
		
		[SetUp]
		public void SetUp()
		{
			r = new ReturnValue("Test Return Value");
		}
		
		[Test]
		public void ValidAddAndRetrieve()
		{
			r.RepeatFinalValue = false;
			r.Add("A");
			r.Add("B");
			
			Assert.AreEqual("A", r.Next());
			Assert.AreEqual("B", r.Next());
		}
		
		[Test]
		public void ValidRepeatedRetrieve()
		{
			r.RepeatFinalValue = true;
			r.Add("A");
			r.Add("B");
			
			Assert.AreEqual("A", r.Next());
			Assert.AreEqual("B", r.Next());
			Assert.AreEqual("B", r.Next());
			Assert.AreEqual("B", r.Next());
			Assert.AreEqual("B", r.Next());			
		}
		
		[Test]
		[ExpectedException(typeof(DotNetMock.AssertionException))]
		public void InvalidRepeatedRetrieve()
		{
			r.Add("A");
			r.Add("B");
			
			Assert.AreEqual("A", r.Next());
			Assert.AreEqual("B", r.Next());
			r.Next();			
		}
		
		[Test]
		public void AddCollection()
		{
			ArrayList args = new ArrayList();
			args.Add("A");
			args.Add("B");
			args.Add("C");
			
			r.AddCollection(args);
			
			Assert.AreEqual("A", r.Next());
			Assert.AreEqual("B", r.Next());
			Assert.AreEqual("C", r.Next());
		}
		
		[Test]
		[ExpectedException(typeof(SystemException))]
		public void ExceptionalValues()
		{
			r.Add("A");
			r.Add(new SystemException("Deliberate exception"));
			
			Assert.AreEqual("A", r.Next());
			r.Next();
		}
	}
}
