using System;
using System.IO;
using NUnit.Framework;

namespace Orciid.Media
{
	[TestFixture]
	public class TestMediaCache
	{
		[Test]
		public void TestDummyMediaCache()
		{
			MediaCache cache = new NullMediaCache();
			using (Stream ws = cache.WriteFile("test.txt"))
				ws.WriteByte(1);
			Stream rs = cache.ReadFile("test.txt", DateTime.MinValue);
			Assert.IsNull(rs);
		}

		[Test]
		public void TestDefaultCacheFileScorer()
		{
			// newer file should have higher score
			int s1 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now - TimeSpan.FromDays(1), DateTime.Now, 1, 1);
			int s2 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now - TimeSpan.FromDays(2), DateTime.Now, 1, 1);
			Assert.IsTrue(s1 > s2);

			// more recently accessed file should have higher score
			s1 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now, DateTime.Now - TimeSpan.FromDays(1), 1, 1);
			s2 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now, DateTime.Now - TimeSpan.FromDays(2), 1, 1);
			Assert.IsTrue(s1 > s2);

			// more frequently read file should have higher score
			s1 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now, DateTime.Now, 2, 1);
			s2 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now, DateTime.Now, 1, 1);
			Assert.IsTrue(s1 > s2);

			// bigger file should have higher score
			s1 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now, DateTime.Now, 1, 10000);
			s2 = MediaCache.DefaultCacheFileScorer(
				DateTime.Now, DateTime.Now, 1, 1000);
			Assert.IsTrue(s1 > s2);
		}
	}
}
