using System;
using System.Data;
using System.IO;
using NUnit.Framework;

namespace Orciid.Media.Util
{
	[TestFixture]
	public class TestCsvWriter
	{
		[Test]
		public void PlainText()
		{
			string s = "one,two,three\n";
			DataTable table = CsvParser.Parse(s);
			string t = CsvWriter.WriteToString(table, false, false);
			Assert.AreEqual(s, t);
		}

		[Test]
		public void QuotedText()
		{
			string s = "\"one\",\"two\",\"three\"\n";
			DataTable table = CsvParser.Parse(s);
			string t = CsvWriter.WriteToString(table, false, true);
			Assert.AreEqual(s, t);
		}

		[Test]
		public void MultiLineText()
		{
			string s = "\"one\nline\",\"two\nline\",\"three\nline\"\n";
			DataTable table = CsvParser.Parse(s);
			string t = CsvWriter.WriteToString(table, false, false);
			Assert.AreEqual(s, t);
		}

		[Test]
		public void Headers()
		{
			string s = "First,Last,Email\nAndreas,Knab,knab2ar@jmu.edu\n";
			DataTable table = CsvParser.Parse(s, true);
			string t = CsvWriter.WriteToString(table, true, false);
			Assert.AreEqual(s, t);
		}

		[Test]
		public void TabbedPlainText()
		{
			string s = "one\ttwo\tthree\n";
			DataTable table = CsvParser.Parse(s, false, '\t');
			string t = CsvWriter.WriteToString(table, false, false, '\t');
			Assert.AreEqual(s, t);
		}

		[Test]
		public void TabbedQuotedText()
		{
			string s = "\"one\"\t\"two\"\t\"three\"\n";
			DataTable table = CsvParser.Parse(s, false, '\t');
			string t = CsvWriter.WriteToString(table, false, true, '\t');
			Assert.AreEqual(s, t);
		}

		[Test]
		public void TabbedMultiLineText()
		{
			string s = "\"one\nline\"\t\"two\nline\"\t\"three\nline\"\n";
			DataTable table = CsvParser.Parse(s, false, '\t');
			string t = CsvWriter.WriteToString(table, false, false, '\t');
			Assert.AreEqual(s, t);
		}

		[Test]
		public void TabbedHeaders()
		{
			string s = "First\tLast\tEmail\nAndreas\tKnab\tknab2ar@jmu.edu\n";
			DataTable table = CsvParser.Parse(s, true, '\t');
			string t = CsvWriter.WriteToString(table, true, false, '\t');
			Assert.AreEqual(s, t);
		}

	
	}
}
