using System;
using System.IO;

namespace Orciid.Media.Util
{
	public class Tools
	{
		public static string GetTempFileName(string extension)
		{
			string tempfile = Path.GetTempFileName();
			string tempfilewithext = tempfile + "." + extension;
			File.Move(tempfile, tempfilewithext);
			return tempfilewithext;
		}

		public static void CopyStream(Stream from, Stream to)
		{
			CopyStream(from, to, 16384);
		}

		public static void CopyStream(Stream from, Stream to, int buffersize)
		{
			byte[] buffer = new byte[buffersize];
			int bytesread;
			do
			{
				bytesread = from.Read(buffer, 0, buffersize);
				if (bytesread > 0)
					to.Write(buffer, 0, bytesread);
			} while (bytesread > 0);
		}
	}
}
